/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.dbforms.devgui.BrowserTool;
import org.dbforms.devgui.DevGui;
import org.dbforms.devgui.ProjectData;
import org.dbforms.devgui.PropertyPanel;

public class WebAppPanel
extends PropertyPanel
implements ActionListener {
    private JButton b_browseApp;
    private JButton b_chooseRoot;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField tf_webAppRoot;
    private JTextField tf_webAppURL;

    public WebAppPanel(DevGui parent) {
        super(parent.getProjectData());
        this.initComponents();
        this.doLayout();
    }

    @Override
    public void setNewProjectData(ProjectData projectData) {
        this.projectData = projectData;
        this.tf_webAppRoot.setText(projectData.getProperty("webAppRoot"));
        this.tf_webAppURL.setText(projectData.getProperty("webAppURL"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.b_chooseRoot) {
            File dlgFile = new File(this.projectData.getProperty("webAppRoot"));
            if (!dlgFile.exists()) {
                dlgFile = null;
            }
            JFileChooser dlg_fileChooser = new JFileChooser(dlgFile);
            dlg_fileChooser.setFileSelectionMode(1);
            dlg_fileChooser.setVisible(true);
            int returnVal = dlg_fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.tf_webAppRoot.setText(dlg_fileChooser.getSelectedFile().getAbsolutePath());
                this.tf_webAppRoot.grabFocus();
            }
        } else if (ev.getSource() == this.b_browseApp) {
            System.out.println("##");
            String webAppURL = this.projectData.getProperty("webAppURL");
            try {
                BrowserTool.openURL(webAppURL);
            }
            catch (IOException ioe) {
                this.showExceptionDialog(ioe);
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel panel_top = new JPanel();
        panel_top.setLayout(new GridLayout(2, 3));
        this.add("North", panel_top);
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Location of Webapp");
        this.jLabel1.setToolTipText("the location of root directory of your web app");
        panel_top.add(this.jLabel1);
        this.tf_webAppRoot = new JTextField();
        this.addAFocusListener(this.tf_webAppRoot, "webAppRoot");
        panel_top.add(this.tf_webAppRoot);
        this.b_chooseRoot = new JButton("change dir...");
        this.b_chooseRoot.addActionListener(this);
        this.b_chooseRoot.setToolTipText("Choose the local root directory of your web application.");
        panel_top.add(this.b_chooseRoot);
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("Web-URL of Webapp");
        panel_top.add(this.jLabel2);
        this.tf_webAppURL = new JTextField("http://127.0.0.1:8080/yourApp");
        this.addAFocusListener(this.tf_webAppURL, "webAppURL");
        panel_top.add(this.tf_webAppURL);
        this.b_browseApp = new JButton("view in browser...");
        this.b_chooseRoot.setToolTipText("Test the application. Web server must be running!");
        this.b_browseApp.addActionListener(this);
        panel_top.add(this.b_browseApp);
    }
}

