/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.conprovider;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.conprovider.ConnectionProvider;
import org.dbforms.util.Util;

public class ProtomatterConnectionProvider
extends ConnectionProvider {
    protected static final String CP_PROPS_INITIALSIZE = "pool.initialSize";
    protected static final String CP_PROPS_MAXSIZE = "pool.maxSize";
    protected static final String CP_PROPS_GROWBLOCK = "pool.growBlock";
    protected static final String CP_PROPS_CREATEWAITTIME = "pool.createWaitTime";
    protected static final String CP_PROPS_VALIDITYCHECKSTATEMENT = "jdbc.validityCheckStatement";
    protected static final String CP_PROPS_MAXCONNECTIONIDLETIME = "pool.maxConnectionIdleTime";
    protected static final String CP_PROPS_MAIDTHREADCHECKINTERVAL = "pool.maidThreadCheckInterval";
    private static final String CP_DRIVER = "com.protomatter.jdbc.pool.JdbcConnectionPoolDriver";
    private static Log logCat = LogFactory.getLog(ProtomatterConnectionProvider.class);

    @Override
    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.getPrefs().getConnectionPoolURL(), this.getPrefs().getUser(), this.getPrefs().getPassword());
    }

    @Override
    protected void init() throws Exception {
        Properties props = null;
        Hashtable<String, Object> args = new Hashtable<String, Object>();
        args.put("jdbc.driver", this.getPrefs().getJdbcDriver());
        args.put("jdbc.URL", this.getPrefs().getJdbcURL());
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("user", this.getPrefs().getUser());
        jdbcProperties.put("password", this.getPrefs().getPassword());
        props = this.getPrefs().getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                jdbcProperties.put(key, props.getProperty(key));
                logCat.info((Object)("::init - JDBC property [" + key + "] = [" + props.getProperty(key) + "]"));
            }
        }
        args.put("jdbc.properties", jdbcProperties);
        props = this.getPrefs().getPoolProperties();
        if (props == null) {
            props = new Properties();
        }
        this.setIntegerArg(args, props, CP_PROPS_INITIALSIZE, "0");
        this.setIntegerArg(args, props, CP_PROPS_MAXSIZE, "-1");
        this.setIntegerArg(args, props, CP_PROPS_GROWBLOCK, "1");
        this.setIntegerArg(args, props, CP_PROPS_CREATEWAITTIME, "0");
        this.setArg(args, props, CP_PROPS_VALIDITYCHECKSTATEMENT, null);
        this.setIntegerArg(args, props, CP_PROPS_MAXCONNECTIONIDLETIME, null);
        this.setIntegerArg(args, props, CP_PROPS_MAIDTHREADCHECKINTERVAL, null);
        Class.forName(CP_DRIVER).newInstance();
    }

    private final void setArg(Hashtable args, Properties props, String key, String defValue) {
        String value = props.getProperty(key, defValue);
        if (!Util.isNull(value)) {
            args.put(key, value);
            logCat.info((Object)("::setArg - [" + key + "] = [" + value + "]"));
        }
    }

    private final void setIntegerArg(Hashtable args, Properties props, String key, String defValue) {
        String value = props.getProperty(key, defValue);
        if (!Util.isNull(value)) {
            args.put(key, new Integer(value));
            logCat.info((Object)("::setIntegerArg - [" + key + "] = [" + value + "]"));
        }
    }
}

