/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Error;
import org.dbforms.util.StringUtil;

public class DbFormsErrors {
    private static Log logCat = LogFactory.getLog((String)DbFormsErrors.class.getName());
    public static final String ERRORS = "dbformsErrors";
    public static final char PARAMETER_DELIMITER = '%';
    private Hashtable errorIDHash;
    private ServletConfig servletConfig;

    public DbFormsErrors() {
        logCat.info((Object)"Create instance of DbFormsErrors");
        this.errorIDHash = new Hashtable();
    }

    public Error getErrorById(String id) {
        return (Error)this.errorIDHash.get(id);
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public String getXMLErrorMessage(String message) {
        String langCode = null;
        String language = null;
        String errorCode = null;
        String paramList = null;
        Error anError = null;
        String xmlMessage = null;
        if (message == null || message.trim().length() == 0) {
            return null;
        }
        try {
            langCode = this.getEmbeddedStringForErrors(message, 0, ':');
            language = this.getEmbeddedStringForErrors(langCode, 0, '-');
            errorCode = this.getEmbeddedStringForErrors(langCode, 1, '-');
            paramList = this.getEmbeddedStringForErrors(message, 1, ':');
        }
        catch (Exception e) {
            logCat.error((Object)"Not in proper format - do not try to convert!");
        }
        if (errorCode != null) {
            if (errorCode.trim().length() == 0) {
                return "";
            }
            anError = this.getErrorById(errorCode);
        }
        if (anError != null) {
            xmlMessage = anError.getMessage(language);
            xmlMessage = xmlMessage != null ? this.insertParametersInString(xmlMessage, paramList) : "No message defined! - check dbForms-error.xml";
            return xmlMessage;
        }
        return message;
    }

    public void addError(Error error) {
        logCat.info((Object)("error added: " + error));
        this.errorIDHash.put(error.getId(), error);
    }

    private String getEmbeddedStringForErrors(String str, int afterDelims, char delim) {
        int lastIndex = 0;
        for (int i = 0; i < afterDelims; ++i) {
            lastIndex = str.indexOf(delim, lastIndex) + 1;
        }
        int nextIndex = str.indexOf(delim, lastIndex);
        if (nextIndex == -1) {
            nextIndex = str.length();
        }
        return str.substring(lastIndex, nextIndex);
    }

    private String insertParametersInString(String xmlMessage, String paramList) {
        int pos = xmlMessage.indexOf(37);
        if (pos < 0 || paramList == null) {
            return xmlMessage;
        }
        Vector v = StringUtil.splitString(paramList, ",");
        int count = 0;
        while (pos >= 0) {
            String prefix = xmlMessage.substring(0, pos);
            String suffix = xmlMessage.substring(pos + 1);
            xmlMessage = prefix + (String)v.elementAt(count);
            xmlMessage = xmlMessage + suffix;
            pos = xmlMessage.indexOf(37);
            ++count;
        }
        return xmlMessage;
    }
}

