/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.model.BindingHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractTableCreator
implements Runnable {
    private Map bindingGroupOffsetCache = new HashMap();

    protected AbstractTableCreator() {
    }

    protected void fillForFieldBindings(Object[] record, List fieldBindings) {
        for (FieldBinding fieldBinding : fieldBindings) {
            int pos = fieldBinding.getPosition() - 1;
            record[pos] = this.createRecordValue(fieldBinding, 0, "");
        }
    }

    protected void fillForFieldSet(Object[] record, FieldSetBinding fieldSetBinding) {
        Iterator it = fieldSetBinding.getBindings();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            if (binding instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)binding;
                Integer position = fieldBinding.getPosition();
                if (position == null || position <= 0) continue;
                record[position.intValue() - 1] = this.createRecordValue(fieldBinding, 0, "");
                continue;
            }
            if (!(binding instanceof FieldGroupBinding)) continue;
            this.fillForStructure(record, (FieldGroupBinding)binding, 0, "");
        }
    }

    protected void fillForStructure(Object[] record, FieldGroupBinding fieldGroupBinding, int offset, String parentStructure) {
        Integer quantity = fieldGroupBinding.getSize();
        Integer bindingGroupOffset = (Integer)this.bindingGroupOffsetCache.get(fieldGroupBinding);
        if (bindingGroupOffset == null) {
            bindingGroupOffset = BindingHelper.getOffset(fieldGroupBinding);
            this.bindingGroupOffsetCache.put(fieldGroupBinding, bindingGroupOffset);
        }
        int len = bindingGroupOffset == 0 ? 0 : quantity;
        for (int i = 0; i < len; ++i) {
            String structure = this.createStructure(parentStructure, fieldGroupBinding, len, i);
            Iterator iter = fieldGroupBinding.getBindings();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                if (binding instanceof FieldBinding) {
                    FieldBinding fieldBinding = (FieldBinding)binding;
                    Integer position = fieldBinding.getPosition();
                    if (position == null || position <= 0) continue;
                    Object value = this.createRecordValue(fieldBinding, offset, structure);
                    int pos = position + offset - 1;
                    record[pos] = value;
                    continue;
                }
                if (!(binding instanceof FieldGroupBinding)) continue;
                this.fillForStructure(record, (FieldGroupBinding)binding, offset, structure);
            }
            offset += bindingGroupOffset.intValue();
        }
    }

    protected String createStructure(String currentStructure, FieldGroupBinding fieldGroupBinding, int quantity, int index) {
        return currentStructure + fieldGroupBinding.getId() + (quantity > 1 ? "[" + (index + 1) + "]." : ".");
    }

    protected abstract Object createRecordValue(FieldBinding var1, int var2, String var3);
}

