/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.MappingProblem;
import de.destatis.core.map.editor.IconFactory;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class RowHeaderTableCellRenderer
extends JComponent
implements TableCellRenderer {
    private MappingProblem[] problems = null;
    private Binding binding = null;
    private int problemType = -1;

    public void setProblems(MappingProblem[] problems) {
        this.problems = problems;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.binding = (Binding)value;
        this.problemType = -1;
        StringBuffer toolTipText = new StringBuffer();
        if (this.problems != null) {
            for (int i = 0; i < this.problems.length; ++i) {
                MappingProblem problem = this.problems[i];
                if (problem.getBinding() != this.binding) continue;
                if (toolTipText.length() > 0) {
                    toolTipText.append("<br>");
                }
                toolTipText.append(problem.getDescription());
                if (this.problemType == -1) {
                    this.problemType = problem.getType();
                    continue;
                }
                if (problem.getType() >= this.problemType) continue;
                this.problemType = problem.getType();
            }
        }
        if (toolTipText.length() > 0) {
            this.setToolTipText("<html>" + toolTipText.toString() + "</html>");
        } else {
            this.setToolTipText(null);
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(SystemColor.control);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.binding instanceof FieldSetBinding) {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, SystemColor.controlDkShadow, 9.0f, 9.0f, SystemColor.control, false);
            ((Graphics2D)g).setPaint(paint);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawOval(0, 0, this.getWidth() * 2, this.getHeight() * 2);
        }
        switch (this.problemType) {
            case 1: {
                IconFactory.getIcon("fatal.gif").paintIcon(this, g, 0, 1);
                break;
            }
            case 2: {
                IconFactory.getIcon("error.gif").paintIcon(this, g, 0, 1);
                break;
            }
            case 3: {
                IconFactory.getIcon("warning.gif").paintIcon(this, g, 0, 1);
                break;
            }
            case 4: {
                IconFactory.getIcon("info.gif").paintIcon(this, g, 0, 1);
            }
        }
    }
}

