/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.dbcp.PoolingDriver;

public class SxPools
extends NamedObjectSet {
    private static final long serialVersionUID = 1L;
    private static NamedObjectSet pools = new NamedObjectSet();
    private static boolean hasMandanten = false;

    private SxPools() {
    }

    public static synchronized Connection getConnection(String poolname) throws SQLException {
        if (pools.size() == 0) {
            throw new IllegalStateException("Kein ConnectionPool gefunden.");
        }
        if (!pools.containsItemWithName(poolname)) {
            throw new SQLException("Kein ConnectionPool f\u00fcr Mandant:" + poolname + " gefunden");
        }
        String pooldrv = "jdbc:apache:commons:dbcp:" + poolname;
        if (DriverManager.getDriver(pooldrv) == null) {
            String msg = "Kein ConnectionPool gefunden ";
            if (!poolname.equals("default")) {
                msg = String.valueOf(msg) + " f\u00fcr Mandant " + poolname;
            }
            throw new SQLException(msg);
        }
        return DriverManager.getConnection(pooldrv);
    }

    public static boolean hasMandanten() {
        return hasMandanten;
    }

    public static int count() {
        return pools.size();
    }

    public static SxPool get(String poolname) {
        if (!pools.containsItemWithName(poolname)) {
            throw new IllegalStateException("Kein ConnectionPool (" + poolname + ") vorhanden");
        }
        return (SxPool)pools.getByName(poolname);
    }

    public static boolean hasPool(String poolname) {
        return pools != null && pools.containsItemWithName(poolname);
    }

    static void initDefaultOnly() throws SQLException, IOException, DBServletException {
        pools.add(new SxPool("default"));
    }

    public static void init() throws SQLException, IOException, DBServletException {
        String mandantenCfg = String.valueOf(SuperXManager.getWEB_INFPfad()) + File.separator + "mandanten.cfg";
        File f2 = new File(mandantenCfg);
        if (!f2.exists()) {
            System.out.println(String.valueOf(DateUtils.getTodayString()) + " " + DateUtils.getNowString());
            System.out.print("Aufbau Datenbank-ConnectionPool");
            SxPool connectionPool = new SxPool("default");
            System.out.println(" OK");
            System.out.println("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection());
            System.out.println("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv"));
            pools.add(connectionPool);
        } else {
            String line;
            hasMandanten = true;
            FileReader fr = new FileReader(f2);
            BufferedReader bfr = new BufferedReader(fr);
            while ((line = bfr.readLine()) != null) {
                System.out.print("Aufbau Datenbank-ConnectionPool f\u00fcr " + line);
                try {
                    SxPool connectionPool = new SxPool(line);
                    System.out.println("OK");
                    System.out.println("           eingeschr\u00e4nkter Datenbankuser f\u00fcr Verbindung: " + connectionPool.isRestrictedConnection());
                    System.out.println("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv"));
                    pools.add(connectionPool);
                }
                catch (Exception e2) {
                    System.out.println("ERROR: Verbindung f\u00fcr " + line + " nicht erfolgreich (" + e2 + ")");
                }
            }
            bfr.close();
            fr.close();
        }
    }

    static void closeAll() throws Exception {
        for (SxPool pool : pools) {
            pool.close();
        }
    }

    public static void main(String[] args) {
        try {
            SxPools.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        boolean i2 = true;
    }

    public static void invalidate(String poolname, Connection con) throws DBServletException {
        if (!pools.containsItemWithName(poolname)) {
            throw new DBServletException("Kann Connection nicht invalidieren - kein ConnectionPool " + poolname + " gefunden.");
        }
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            driver.getConnectionPool(poolname).invalidateObject((Object)con);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new DBServletException("Invalidating connection failed -" + e2);
        }
    }

    public static String getPoolFinRechteInfos() {
        StringBuffer result = new StringBuffer();
        for (SxPool aPool : pools) {
            result.append("Mandant: " + aPool.getName() + " - SxFinRechtevariante:" + aPool.getFinRightVariantName() + "<br>");
        }
        return result.toString();
    }

    public static void resetAllPools() throws TransformerConfigurationException, SQLException, DBServletException {
        for (SxPool aPool : pools) {
            try {
                aPool.init();
            }
            catch (Exception e2) {
                System.out.println("ERROR: Datenreset f\u00fcr " + aPool.getName() + " fehlgeschlagen:" + e2);
                e2.printStackTrace();
            }
        }
    }

    public static void clearLogFiles() throws IOException {
        for (SxPool aPool : pools) {
            aPool.clearLogFiles();
        }
    }
}

