/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;

public class SxDefaults {
    static Hashtable defaults_map = new Hashtable();
    static String propertyFile = null;
    static String defaultServerUrl;

    public static void setPropertyFile(String file) {
        propertyFile = new String(file);
    }

    public static void addProperty(String name, Object nkey, Object nvalue) {
        Properties prop = new Properties();
        prop.put("key", nkey);
        prop.put("value", nvalue);
        defaults_map.put(name, prop);
    }

    public static Properties getProperty(String name) {
        Properties prop = (Properties)defaults_map.get(name);
        return prop;
    }

    public static Object getPropertyValue(String name) {
        Properties prop = (Properties)defaults_map.get(name);
        if (prop != null) {
            return prop.getProperty("value");
        }
        String msg = "Property '" + name + "' in 'superx.properties' nicht gefunden !";
        throw new NullPointerException(msg);
    }

    public static void contents() {
        Enumeration en = defaults_map.keys();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Properties prop = SxDefaults.getProperty(name);
            if (prop == null) continue;
            Object key = prop.get("key");
            Object object = prop.get("value");
        }
    }

    public static void clear() {
        defaults_map.clear();
        defaults_map = new Hashtable();
        SxDefaults.init();
    }

    public static void init() {
        Properties props = new Properties();
        boolean b_len = false;
        String prop_file = propertyFile != null ? propertyFile : "file:superx.properties";
        try {
            URL props_url = new URL(prop_file);
            InputStream is = props_url.openStream();
            if (is == null) {
                String msg = "Ressourcedatei '" + prop_file + "' nicht gefunden.";
                throw new IOException(msg);
            }
            props.load(is);
            is.close();
            if (props.getProperty("SxServerURL") == null) {
                props.setProperty("SxServerURL", defaultServerUrl);
            }
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = props.getProperty(key);
                SxDefaults.addProperty(key, key, value);
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
            JOptionPane.showMessageDialog(null, ex.toString(), "Fehler", 0);
        }
    }

    public static void setDefaultServerUrl(String url) {
        defaultServerUrl = url;
    }
}

