/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.common.GraphicFormat;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ChartCreator {
    private static String xmlPath;

    public static void initPath(String path) {
        xmlPath = path;
    }

    public static BufferedImage create(StringBuffer tableXml, StringBuffer headerXml, GraphicFormat f) {
        return null;
    }

    public static File createFile(StringBuffer tableXml, GraphicFormat f) throws IOException {
        JFreeChart jfreechart = null;
        if (f.getCharttype().toLowerCase().indexOf("bar") > -1) {
            jfreechart = ChartCreator.createBarChart(tableXml, f);
        }
        if (f.getCharttype().toLowerCase().indexOf("pie") > -1) {
            jfreechart = ChartCreator.createPieChart(tableXml, f);
        }
        if (f.getCharttype().toLowerCase().indexOf("line") > -1) {
            jfreechart = ChartCreator.createLineChart(tableXml, f);
        }
        if (jfreechart == null) {
            throw new IllegalStateException("Keine Grafik erstellt - unbekannter charttype " + f.getCharttype());
        }
        long graphicId = new Date().getTime();
        File file = new File(xmlPath + "/tmp" + graphicId + ".png");
        System.out.println(f);
        FileOutputStream fos = new FileOutputStream(file);
        ChartUtilities.writeChartAsPNG((OutputStream)fos, (JFreeChart)jfreechart, (int)f.getWidth(), (int)f.getHeight());
        fos.close();
        return file;
    }

    private static JFreeChart createLineChart(StringBuffer tableXml, GraphicFormat f) {
        DefaultCategoryDataset dataset = ChartCreator.createCategoryDataSet(tableXml, f);
        PlotOrientation orient = PlotOrientation.VERTICAL;
        JFreeChart chart = ChartFactory.createLineChart((String)f.getCaption(), (String)f.getCaptionx(), (String)f.getCaptiony(), (CategoryDataset)dataset, (PlotOrientation)orient, (boolean)true, (boolean)false, (boolean)false);
        f.applyParams(chart.getPlot());
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        return chart;
    }

    private static JFreeChart createPieChart(StringBuffer tableXml, GraphicFormat f) {
        DefaultCategoryDataset cdataset = ChartCreator.createCategoryDataSet(tableXml, f);
        int tableColumn = f.getPieChartColumn();
        CategoryToPieDataset dataset = new CategoryToPieDataset((CategoryDataset)cdataset, TableOrder.BY_ROW, tableColumn - 2);
        boolean isLegendWanted = false;
        if (!f.isShowValuesWanted()) {
            isLegendWanted = true;
        }
        JFreeChart chart = f.getCharttype().toUpperCase().indexOf("3D") > -1 ? ChartFactory.createPieChart3D((String)f.getCaption(), (PieDataset)dataset, (boolean)isLegendWanted, (boolean)false, (boolean)false) : ChartFactory.createPieChart((String)f.getCaption(), (PieDataset)dataset, (boolean)isLegendWanted, (boolean)false, (boolean)false);
        String rowkey = null;
        try {
            rowkey = cdataset.getRowKey(tableColumn - 2).toString();
        }
        catch (RuntimeException e) {
            String msg = "Konnte Bezeichnung aus Spalte " + tableColumn + " nicht ermitteln.";
            if (f.hasParam("USENO")) {
                msg = msg + " UseNo in GraphicFormat " + f.getId() + " pr\u00fcfen\n";
            }
            throw new IllegalArgumentException(msg + e.toString());
        }
        chart.addSubtitle((Title)new TextTitle(rowkey));
        f.applyParams(chart.getPlot());
        return chart;
    }

    private static JFreeChart createBarChart(StringBuffer tableXml, GraphicFormat f) {
        DefaultCategoryDataset dataset = ChartCreator.createCategoryDataSet(tableXml, f);
        PlotOrientation orient = PlotOrientation.VERTICAL;
        if (f.getCharttype().indexOf("hbar") > -1) {
            orient = PlotOrientation.HORIZONTAL;
        }
        JFreeChart chart = f.getCharttype().toUpperCase().indexOf("3D") > -1 ? ChartFactory.createBarChart3D((String)f.getCaption(), (String)f.getCaptionx(), (String)f.getCaptiony(), (CategoryDataset)dataset, (PlotOrientation)orient, (boolean)true, (boolean)false, (boolean)false) : ChartFactory.createBarChart((String)f.getCaption(), (String)f.getCaptionx(), (String)f.getCaptiony(), (CategoryDataset)dataset, (PlotOrientation)orient, (boolean)true, (boolean)false, (boolean)false);
        f.applyParams(chart.getPlot());
        return chart;
    }

    private static DefaultCategoryDataset createCategoryDataSet(StringBuffer tableXml, GraphicFormat f) {
        XMLUtils.getExceptionHandler().setExitWanted(false);
        tableXml = new StringBuffer(tableXml.toString().replaceAll("-<p class='smallBreak'></p>\n ", ""));
        tableXml = new StringBuffer(tableXml.toString().replaceAll("<p class='smallBreak'></p>\n ", ""));
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Document d = XMLUtils.buildDocumentFromString(tableXml.toString(), false);
        Node headers = XMLUtils.getFirstNode(d, "headers");
        String[] names = new String[XMLUtils.getChildNodeCount(headers, "header")];
        int i = 0;
        Iterator it = XMLUtils.getChildNodeIterator(headers);
        while (it.hasNext()) {
            Node header = (Node)it.next();
            names[i] = XMLUtils.getChildNodeValue(header, "wert");
            if (names[i] != null) {
                names[i] = names[i].trim();
                StringBuffer b = new StringBuffer(names[i]);
                StringUtils.replace(b, "-\\n ", "");
                StringUtils.replace(b, "\\n", " ");
                names[i] = b.toString();
            }
            ++i;
        }
        Node sqlerg = XMLUtils.getFirstNode(d, "sqlerg");
        Iterator it2 = XMLUtils.getChildNodeIterator(sqlerg);
        block1: while (it2.hasNext()) {
            Node rowNode = (Node)it2.next();
            if (!rowNode.getNodeName().equals("row")) continue;
            int colnr = 0;
            String rowname = "";
            Iterator it22 = XMLUtils.getChildNodeIterator(rowNode);
            while (it22.hasNext()) {
                Node colNode = (Node)it22.next();
                if (!colNode.getNodeName().equals("col")) continue;
                String value = XMLUtils.getChildNodeValue(colNode, "wert");
                if (colnr == 0) {
                    if (value == null || value.trim().equals("")) continue block1;
                    rowname = value.trim();
                    rowname = rowname.replaceAll("-<p class='smallBreak'></p>\n ", "");
                    rowname = rowname.replaceAll("<p class='smallBreak'></p>\n ", "");
                    rowname = rowname.replaceAll("-\\n ", "");
                    if (!f.isRowWanted(rowname = rowname.replaceAll("\\n", " "))) continue block1;
                    ++colnr;
                    continue;
                }
                if (!f.isColWanted(colnr + 1)) {
                    ++colnr;
                    continue;
                }
                double val = 0.0;
                if (value != null && !value.equals("")) {
                    val = Double.parseDouble(value);
                }
                if (f.isFlipFlopWanted()) {
                    dataset.addValue(val, (Comparable)((Object)rowname), (Comparable)((Object)names[colnr]));
                } else {
                    dataset.addValue(val, (Comparable)((Object)names[colnr]), (Comparable)((Object)rowname));
                }
                ++colnr;
            }
        }
        return dataset;
    }

    private static DefaultCategoryDataset createDataSet(SuperX_el result_el) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SxResultRow row : result_el.getResultSet()) {
            String rowKey = (String)row.get(0);
            for (int i = 1; i < result_el.getColumnCount(); ++i) {
                Object value = row.get(i);
                double val = 0.0;
                if (value != null) {
                    val = Double.parseDouble(value.toString());
                }
                dataset.addValue(val, (Comparable)((Object)rowKey), (Comparable)((Object)result_el.getColumnLabels()[i]));
            }
        }
        return dataset;
    }
}

