/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class ValueRandomizer {
    private static String driver = "org.postgresql.Driver";
    private static String dbUrl = "jdbc:postgresql://localhost:5432/superx";
    private static String username = "superx";
    private static String password = "";
    private static String tablename = "cob_busa";
    private static String colname = "betrag";
    private static String datenart = "DOUBLE";
    private static double minFactor = 0.6;
    private static double maxFactor = 1.8;
    private static boolean printOutOnly = false;
    private static Statement stat;
    private static Random r;

    public static void main(String[] args) {
        try {
            Class.forName(driver);
            System.out.println("establishing connection to " + dbUrl);
            Connection conn = DriverManager.getConnection(dbUrl, username, password);
            stat = conn.createStatement();
            System.out.println("done.");
            ValueRandomizer.out();
            stat.close();
            conn.close();
            System.exit(-1);
            Vector werte = ValueRandomizer.readDistinctValues();
            if (datenart.toUpperCase().equalsIgnoreCase("DOUBLE")) {
                ValueRandomizer.randomize(werte);
            } else {
                ValueRandomizer.massiveRandomizeInteger(werte);
            }
            System.out.println("Randomizierung erfolgreich beendet");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(0);
        }
    }

    private static void randomize(Vector werte) {
        int categories = 15;
        int valuesPerCategory = werte.size() / categories;
        StringBuffer updates = new StringBuffer();
        float limit = 0.0f;
        for (int i = 1; i < categories; ++i) {
            limit = (float)((Double)werte.get(i * valuesPerCategory)).doubleValue();
            updates.append("update " + tablename + " set " + colname + "=" + colname + "*" + ValueRandomizer.getRndFactor() + " where " + colname + ">" + limit);
            if (i > 1) {
                float limit2 = (float)((Double)werte.get((i - 1) * valuesPerCategory)).doubleValue();
                updates.append(" and " + colname + "<" + limit2);
            }
            updates.append(";\n");
        }
        limit = (float)((Double)werte.get((categories - 1) * valuesPerCategory)).doubleValue();
        updates.append("update " + tablename + " set " + colname + "=" + colname + "*" + ValueRandomizer.getRndFactor() + " where " + colname + "<" + limit + ";");
        System.out.println(updates);
    }

    private static void massiveRandomizeInteger(Vector werte) throws SQLException {
        String upd = null;
        Enumeration en = werte.elements();
        while (en.hasMoreElements()) {
            Integer einWert = (Integer)en.nextElement();
            int neuerwert = (int)((float)einWert.intValue() * ValueRandomizer.getRndFactor());
            upd = "update " + tablename + " set " + colname + "=" + neuerwert + " where " + colname + "=" + einWert.toString() + ";";
            if (printOutOnly) {
                System.out.println(upd);
                continue;
            }
            stat.executeUpdate(upd);
        }
    }

    private static void massiveRandomizeDouble(Vector werte) throws SQLException {
        int i = 0;
        int count = werte.size();
        Enumeration en = werte.elements();
        while (en.hasMoreElements()) {
            Double einWert = (Double)en.nextElement();
            ++i;
            double zufallswert = einWert * (double)ValueRandomizer.getRndFactor();
            String upd = "update " + tablename + " set " + colname + "=" + zufallswert + " where " + colname + "=" + einWert + ";";
            if (printOutOnly) {
                System.out.println(upd);
                continue;
            }
            stat.executeUpdate(upd);
            if (i % 20 != 0) continue;
            System.out.println("Done " + i + " updates of " + count);
        }
    }

    private static float getRndFactor() {
        double rnd;
        for (rnd = Math.abs(r.nextDouble()); rnd < minFactor; rnd += minFactor) {
        }
        while (rnd > maxFactor) {
            rnd -= 0.05;
        }
        return (float)rnd;
    }

    private static Vector readDistinctValues() throws SQLException {
        Vector<Object> werte = new Vector<Object>();
        ResultSet rs = null;
        System.out.println("Alle werte einlesen:select distinct " + colname + " from " + tablename + " order by 1 DESC");
        rs = stat.executeQuery("select distinct " + colname + " from " + tablename + " order by " + colname + " DESC");
        while (rs.next()) {
            Object item = rs.getObject(1);
            werte.add(item);
        }
        rs.close();
        return werte;
    }

    private static void out() {
        try {
            FileWriter fw = new FileWriter("c:\\cygwin\\home\\superx\\cob_busa.unl");
            BufferedWriter bw = new BufferedWriter(fw);
            StringBuffer buf = new StringBuffer();
            ResultSet rs = stat.executeQuery("select * from cob_busa");
            int cols = 20;
            while (rs.next()) {
                for (int i = 1; i <= cols; ++i) {
                    Object o = rs.getObject(i);
                    String s = o == null ? "" : o.toString();
                    buf.append(s.trim() + "^");
                }
                buf.append("^\n");
            }
            rs.close();
            bw.write(buf.toString());
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("done");
    }

    static {
        r = new Random();
    }
}

