/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.trace;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

abstract class Logger {
    protected int m_iEbene = 0;
    protected Calendar m_cal = Calendar.getInstance();
    protected Date newTime;
    protected String m_sZeitpunkt = new String();
    protected int m_iJahr;
    protected int m_iMonat;
    protected int m_iTag;
    protected int m_iStd;
    protected int m_iMin;
    protected int m_iSek;
    protected int m_iMilli;
    protected StringBuffer m_sbZeit = new StringBuffer();
    protected List m_listFuncs;
    protected String user;
    protected int errorThreshold;
    protected boolean debug;

    public Logger(boolean debug, int errorThreshold) {
        this.user = "";
        this.debug = debug;
        this.errorThreshold = errorThreshold;
        this.m_listFuncs = Collections.synchronizedList(new ArrayList());
    }

    public Logger(boolean debug, int errorThreshold, String user) {
        this.user = user;
        this.debug = debug;
        this.errorThreshold = errorThreshold;
        this.m_listFuncs = Collections.synchronizedList(new ArrayList());
    }

    public boolean getDebug() {
        return this.debug;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public String getUser() {
        return this.user;
    }

    public void setErrorThreshold(int threshold) {
        this.errorThreshold = threshold;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void now() {
        this.newTime = new Date();
        this.m_cal.setTime(this.newTime);
        this.m_iJahr = this.m_cal.get(1);
        this.m_iMonat = this.m_cal.get(2) + 1;
        this.m_iTag = this.m_cal.get(5);
        this.m_iStd = this.m_cal.get(11);
        this.m_iMin = this.m_cal.get(12);
        this.m_iSek = this.m_cal.get(13);
        this.m_iMilli = this.m_cal.get(14);
        this.m_sbZeit = new StringBuffer(20);
        this.m_sbZeit.append(this.m_iJahr).append(this.m_iMonat).append(this.m_iTag).append(":").append(this.m_iStd).append(this.m_iMin).append(this.m_iSek).append(".").append(this.m_iMilli).append(":");
        if (this.m_iMonat < 10) {
            this.m_sbZeit.insert(4, 0);
        }
        if (this.m_iTag < 10) {
            this.m_sbZeit.insert(6, 0);
        }
        if (this.m_iStd < 10) {
            this.m_sbZeit.insert(9, 0);
        }
        if (this.m_iMin < 10) {
            this.m_sbZeit.insert(11, 0);
        }
        if (this.m_iSek < 10) {
            this.m_sbZeit.insert(13, 0);
        }
        if (this.m_iMilli < 100) {
            this.m_sbZeit.insert(16, 0);
        }
        if (this.m_iMilli < 10) {
            this.m_sbZeit.insert(16, 0);
        }
    }

    public abstract void print(int var1, String var2);

    public abstract void enter(String var1, String var2);

    public abstract void enter(int var1, String var2, String var3);

    public abstract void leave();

    public abstract void leave(int var1);
}

