/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.trace;

import de.werum.sis.trace.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class DBLogger
extends Logger {
    private static DBLogger myDBLogger = null;
    private String jdbcdriver;
    private String URL;
    private String user;
    private String login;
    private String password;
    private String insertstatement;
    private Connection con;
    private Statement stmt;
    private ResultSet rs;
    private int inserted_rows;

    private DBLogger(String jdbcdriver, String url, boolean debug, int errorThreshold, String user, String login, String password) {
        super(debug, errorThreshold, user);
        this.jdbcdriver = jdbcdriver;
        this.URL = url;
        this.user = user;
        this.login = login;
        this.password = password;
        try {
            Class.forName(jdbcdriver);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("Datenbank-Treiber" + jdbcdriver + "nicht gefunden!");
        }
        try {
            this.stmt = this.con.createStatement();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void print(int errorLevel, String sMsg) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            StringTokenizer strtoken = new StringTokenizer(this.m_listFuncs.get(this.m_iEbene - 1).toString(), ", ");
            String klasse = strtoken.nextToken();
            String methode = strtoken.nextToken();
            try {
                this.con = DriverManager.getConnection(this.URL, this.login, this.password);
                int ct = this.stmt.executeUpdate("insert into ws_error_logg (error_id, benutzer, datum, klasse, methode, error_level, meldung_text) values(error_id.nextval,'" + this.user + "',SYSDATE,'" + klasse + "','" + methode + "','" + errorLevel + "','" + sMsg + "')");
                this.con.commit();
            }
            catch (SQLException ex) {
                System.out.println("Log konnte nicht in die DB geschrieben werden");
            }
        }
    }

    protected void finalize() {
        try {
            this.con.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void enter(String klasse, String methode) {
        if (this.debug) {
            this.m_listFuncs.add(klasse + ", " + methode);
            ++this.m_iEbene;
        }
    }

    public void enter(int errorLevel, String klasse, String methode) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.enter(klasse, methode);
        }
    }

    public void leave() {
        if (this.debug) {
            --this.m_iEbene;
            this.m_listFuncs.remove(this.m_iEbene);
        }
    }

    public void leave(int errorLevel) {
        if (this.debug && errorLevel <= this.errorThreshold) {
            this.leave();
        }
    }

    public static DBLogger getInstance(String jdbcdriver, String url, boolean debug, int errorThreshold, String user, String login, String password) {
        if (myDBLogger == null) {
            myDBLogger = new DBLogger(jdbcdriver, url, debug, errorThreshold, user, login, password);
        }
        return myDBLogger;
    }
}

