/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.util;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.util.PointXY;
import de.werum.sis.mapping.util.Triangle;

public class MathHelper {
    private static final Triangle triangle_ = new Triangle();
    public static final double VARIANCE = 0.07;

    public static final synchronized boolean isInRange(PointXY p1, PointXY p2, PointXY tocheck, int maxDistance) {
        triangle_.init(p1, p2, tocheck);
        double hb = triangle_.hb();
        double ha = triangle_.ha();
        if (Logger.getInstance().isDebug()) {
            Logger.getInstance().debug("isInRange,param", "P1:" + p1.toString() + " P2:" + p2.toString() + " C:" + tocheck.toString() + " Range:" + maxDistance);
            Logger.getInstance().debug("isInRange, Tri", triangle_.toString());
            Logger.getInstance().debug("isInRange, ha ", "ha:" + ha);
            Logger.getInstance().debug("isInRange, hb ", "hb:" + hb);
            Logger.getInstance().debug("isInRange, ha<=maxdist", ha <= (double)maxDistance ? "- T R U E -" : "-false-");
            Logger.getInstance().debug("isInRange, hb<=maxdist", hb <= (double)maxDistance ? "- T R U E -" : "-false-");
        }
        return hb <= (double)maxDistance || ha <= (double)maxDistance;
    }

    public static boolean isOnVector(PointXY p1, PointXY p2, PointXY tocheck, double variance) {
        if (p2.Y - p1.Y == 0 && tocheck.Y - p1.Y == 0) {
            return p1.X >= tocheck.X && p2.X <= tocheck.X;
        }
        if (p2.Y - p1.Y == 0 || tocheck.Y - p1.Y == 0) {
            return false;
        }
        double result = (double)(p2.X - p1.X) / (double)(p2.Y - p1.Y) - (double)(tocheck.X - p1.X) / (double)(tocheck.Y - p1.Y);
        return result < variance && result > 0.0 - variance;
    }

    public static boolean isOnVector(PointXY p1, PointXY p2, PointXY tocheck) {
        Logger.getInstance().log(40, (Object)"isOnVector", "with default VARIANCE:0.07");
        return MathHelper.isOnVector(p1, p2, tocheck, 0.07);
    }

    public static boolean isOnVector(PointXY p1, PointXY p2, PointXY tocheck, int diviation) {
        if (diviation <= 0) {
            return MathHelper.isOnVector(p1, p2, tocheck);
        }
        if (MathHelper.isOnVector(p1, p2, tocheck)) {
            return true;
        }
        for (int count = 1; count <= diviation; ++count) {
            if (MathHelper.isOnVector(new PointXY(p1.X, p1.Y + count), new PointXY(p2.X, p2.Y + count), tocheck)) {
                return true;
            }
            if (!MathHelper.isOnVector(new PointXY(p1.X, p1.Y - count), new PointXY(p2.X, p2.Y - count), tocheck)) continue;
            return true;
        }
        return false;
    }
}

