/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.inspector;

import de.statspez.pleditor.generator.interpreter.ClassificationFactory;
import de.statspez.pleditor.generator.interpreter.DefaultClassificationFactory;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.sdf.generator.inspector.DataInspectionProblem;
import de.statspez.sdf.generator.inspector.Field;
import de.statspez.sdf.generator.inspector.FieldGroup;
import de.statspez.sdf.generator.inspector.PlausiDataset;
import de.statspez.sdf.generator.inspector.Report;
import de.statspez.sdf.generator.interpreter.SDFFieldDescriptorFactory;
import de.statspez.sdf.generator.meta.MetaCustomSDFBedingung;
import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.util.FeaturesVisitor;
import de.statspez.sdf.generator.meta.util.HelpFeaturesVisitor;
import de.statspez.sdf.generator.meta.util.SDFStructureHelper;
import de.statspez.sdf.generator.util.SDFUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class DataInspector {
    private final MetaErhebungsbeschreibung surveyDefinition;
    private final ProgramInterpreter interpreter;
    private final SDFFieldDescriptorFactory fieldDescriptorFactory;
    private final ClassificationFactory classificationFactory;

    public DataInspector(MetaErhebungsbeschreibung surveyDefinition) {
        this.surveyDefinition = surveyDefinition;
        this.interpreter = new ProgramInterpreter();
        this.fieldDescriptorFactory = new SDFFieldDescriptorFactory(surveyDefinition);
        this.classificationFactory = new DefaultClassificationFactory();
        Iterator iter = this.fieldDescriptorFactory.getClassificationGroups();
        while (iter != null && iter.hasNext()) {
            ClassificationGroup classGroup = (ClassificationGroup)iter.next();
            this.classificationFactory.registerClassificationGroup(classGroup.value().asString(), classGroup);
        }
    }

    public DataInspectionProblem[] checkHelpFeatures(Report report, FieldGroup helpFeatures) {
        ArrayList problemList = new ArrayList();
        new HelpFeaturesInspector().check(report, helpFeatures, problemList);
        return problemList.toArray(new DataInspectionProblem[problemList.size()]);
    }

    public MetaSDFAusgabegruppe findDataGroup(Report report, FieldGroup record) {
        if (SDFStructureHelper.hasManyDataGroups(this.surveyDefinition.getAusgabesatz())) {
            HashMap<String, String> recordValues = new HashMap<String, String>();
            MetaSDFAusgabegruppe defaultOutputGroup = SDFStructureHelper.getDeafaultDataGroup(this.surveyDefinition.getAusgabesatz());
            Iterator references = defaultOutputGroup.getSDFFeldReferenzen();
            while (references != null && references.hasNext()) {
                Field field;
                MetaCustomSDFFeldReferenz reference = (MetaCustomSDFFeldReferenz)references.next();
                if (!reference.isIstSelektor() || (field = record.getField(reference.getReferenceName())) == null || field.getValue() == null) continue;
                recordValues.put(field.getName(), SDFUtil.getNormalizedValue(field.getValue(), (MetaCustomSDFMerkmal)reference.getKlasse(), report.getDecimalSeparator(), report.getThousandGroupSeparator()));
            }
            return SDFStructureHelper.findDataGroup(this.surveyDefinition, recordValues);
        }
        return SDFStructureHelper.getDeafaultDataGroup(this.surveyDefinition.getAusgabesatz());
    }

    public DataInspectionProblem[] checkRecord(Report report, FieldGroup record, FieldGroup helpFeatures) {
        ArrayList<DataInspectionProblem> problemList = new ArrayList<DataInspectionProblem>();
        MetaSDFAusgabegruppe dataGroup = this.findDataGroup(report, record);
        if (dataGroup != null) {
            report.countRecord(dataGroup);
            this.checkInvalidFields(report, dataGroup, record, null, problemList);
            this.fieldDescriptorFactory.setCurrentOutputGroup(dataGroup);
            InterpreterContext context = new InterpreterContext();
            context.setFieldDescriptorFactory((FieldDescriptorFactory)this.fieldDescriptorFactory);
            context.setClassificationFactory(this.classificationFactory);
            context.setSatz((SatzInterface)new PlausiDataset(record));
            new RecordInspector().check(dataGroup, record, helpFeatures, problemList);
            this.fieldDescriptorFactory.setCurrentOutputGroup(null);
        } else {
            problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_RECORD, "Der Satz muss einer der definierten Satzarten entsprechen.", null, record.getContext(), null, null));
        }
        return problemList.toArray(new DataInspectionProblem[problemList.size()]);
    }

    public DataInspectionProblem[] checkReport(Report report) {
        ArrayList<DataInspectionProblem> problemList = new ArrayList<DataInspectionProblem>();
        if (report.getNumOfRecords() > 0) {
            MetaSDFAusgabesatz outputDataModel = this.surveyDefinition.getAusgabesatz();
            if (outputDataModel != null) {
                Iterator iter = outputDataModel.getAusgabegruppen();
                while (iter != null && iter.hasNext()) {
                    MetaSDFAusgabegruppe dataGroup = (MetaSDFAusgabegruppe)iter.next();
                    if (1 != dataGroup.getAttributDaten()) continue;
                    int numOfRecords = report.getNumOfRecords(dataGroup);
                    int minOccurs = SDFUtil.getMinOccurs(dataGroup.getMinimaleAnzahl());
                    int maxOccurs = SDFUtil.getMaxOccurs(dataGroup.getMaximaleAnzahl());
                    if (minOccurs != -1 && numOfRecords < minOccurs) {
                        if (maxOccurs != -1 && minOccurs == maxOccurs) {
                            problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_RECORDS, "Es m\u00fcssen genau " + minOccurs + " Datens\u00e4tze geliefert werden.", dataGroup.getName(), null, null, null));
                        } else {
                            problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_RECORDS, "Es m\u00fcssen mindestens " + minOccurs + " Datens\u00e4tze geliefert werden.", dataGroup.getName(), null, null, null));
                        }
                    }
                    if (maxOccurs == -1 || numOfRecords <= maxOccurs) continue;
                    if (minOccurs != -1 && minOccurs == maxOccurs) {
                        problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_RECORDS, "Es m\u00fcssen genau " + maxOccurs + " Datens\u00e4tze geliefert werden.", dataGroup.getName(), null, null, null));
                        continue;
                    }
                    problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_RECORDS, "Es d\u00fcrfen h\u00f6chstens " + maxOccurs + " Datens\u00e4tze geliefert werden.", dataGroup.getName(), null, null, null));
                }
            }
        } else {
            problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.NO_RECORDS, "Es muss mindestens 1 Datensatz geliefert werden.", null, null, null, null));
        }
        return problemList.toArray(new DataInspectionProblem[problemList.size()]);
    }

    private void checkFeatureValue(MetaCustomSDFMerkmal merkmal, Field field, boolean helpFeature, boolean required, InterpreterContext context, List<DataInspectionProblem> problemList) {
        MetaProgram metaProgramm = merkmal.getSpecification();
        if (metaProgramm != null) {
            try {
                context.setCurrentField(this.fieldDescriptorFactory.getFieldDescriptor(merkmal.getName()));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            try {
                if (!this.interpreter.execute(metaProgramm, context).asBoolean()) {
                    problemList.add(new DataInspectionProblem(helpFeature ? (required ? DataInspectionProblem.Type.INVALID_REQUIRED_HELP_FEATURE_VALUE : DataInspectionProblem.Type.INVALID_OPTIONAL_HELP_FEATURE_VALUE) : (required ? DataInspectionProblem.Type.INVALID_REQUIRED_FEATURE_VALUE : DataInspectionProblem.Type.INVALID_OPTIONAL_FEATURE_VALUE), "Der Wert des " + (helpFeature ? "Hilfsmerkmals" : "Merkmals") + " liegt nicht im definierten Wertebereich.", field.getName(), field.getContext(), null, null));
                }
            }
            catch (Exception e) {
                problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.SDF_FORMAT_ERROR, "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.", field.getName(), null, null, e));
            }
        }
    }

    private void checkInvalidFields(Report report, MetaSDFAusgabegruppe dataGroup, FieldGroup fieldGroup, String structure, List<DataInspectionProblem> problemList) {
        for (Field field : fieldGroup.getFields()) {
            MetaCustomSDFFeldReferenz featureRef = SDFStructureHelper.findFeature(dataGroup, structure != null ? String.valueOf(structure) + "." + field.getName() : field.getName());
            if (featureRef == null) {
                problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_FEATURE, "Das Merkmal ist an dieser Stelle unzul\u00e4ssig.", field.getName(), field.getContext(), null, null));
                continue;
            }
            field.setValue(SDFUtil.getNormalizedValue(field.getValue(), (MetaCustomSDFMerkmal)featureRef.getKlasse(), report.getDecimalSeparator(), report.getThousandGroupSeparator()));
        }
        for (List list : fieldGroup.getFieldGroups()) {
            FieldGroup firstFieldGroup = (FieldGroup)list.get(0);
            if (SDFStructureHelper.findFeatureGroup(dataGroup, structure != null ? String.valueOf(structure) + "." + firstFieldGroup.getName() : firstFieldGroup.getName()) == null) {
                problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_FEATURE_GROUP, "Die Merkmalsgruppe ist an dieser Stelle unzul\u00e4ssig.", firstFieldGroup.getName(), firstFieldGroup.getContext(), null, null));
                continue;
            }
            for (FieldGroup subFieldGroup : list) {
                this.checkInvalidFields(report, dataGroup, subFieldGroup, structure != null ? String.valueOf(structure) + "." + subFieldGroup.getName() : subFieldGroup.getName(), problemList);
            }
        }
    }

    private class HelpFeaturesInspector
    extends HelpFeaturesVisitor {
        private FieldGroup helpFeatures;
        private List<DataInspectionProblem> problemList;
        private InterpreterContext context;
        private MetaSDFAusgabegruppe dataGroup;

        private HelpFeaturesInspector() {
        }

        private void check(Report report, FieldGroup helpFeatures, List<DataInspectionProblem> problemList) {
            this.helpFeatures = helpFeatures;
            this.problemList = problemList;
            for (Field helpFeature : helpFeatures.getFields()) {
                MetaCustomSDFFeldReferenz helpFeatureRef = SDFStructureHelper.findHelpFeature(DataInspector.this.surveyDefinition, helpFeature.getName());
                if (helpFeatureRef == null) {
                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_HELP_FEATURE, "Das Hilfsmerkmal ist an dieser Stelle unzul\u00e4ssig.", helpFeature.getName(), helpFeature.getContext(), null, null));
                    continue;
                }
                helpFeature.setValue(SDFUtil.getNormalizedValue(helpFeature.getValue(), (MetaCustomSDFMerkmal)helpFeatureRef.getKlasse(), report.getDecimalSeparator(), report.getThousandGroupSeparator()));
            }
            this.context = new InterpreterContext();
            this.context.setFieldDescriptorFactory((FieldDescriptorFactory)DataInspector.this.fieldDescriptorFactory);
            this.context.setClassificationFactory(DataInspector.this.classificationFactory);
            this.context.setSatz((SatzInterface)new PlausiDataset(helpFeatures));
            DataInspector.this.surveyDefinition.accept(this);
        }

        @Override
        public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
            this.dataGroup = ausgabegruppe;
            super.visitSDFAusgabegruppe(ausgabegruppe);
        }

        @Override
        public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
            MetaCustomSDFMerkmal helpFeature = (MetaCustomSDFMerkmal)feldReferenz.getKlasse();
            Field field = this.helpFeatures.getField(helpFeature.getName());
            boolean conditionFound = false;
            boolean conditionFulfilled = false;
            Iterator iter = this.dataGroup.getSDFBedingungen();
            while (!conditionFound && iter != null && iter.hasNext()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)iter.next();
                if (!SDFUtil.getReferenceField(condition.getBezugsfeld()).equals(helpFeature.getName())) continue;
                if (3 != condition.getBedingungsTyp()) {
                    if (condition.getSpecification() != null) {
                        try {
                            conditionFulfilled = DataInspector.this.interpreter.execute(condition.getSpecification(), this.context).asBoolean();
                        }
                        catch (Exception e) {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.SDF_FORMAT_ERROR, "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.", helpFeature.getName(), null, condition.getBedingung(), e));
                        }
                        if (conditionFulfilled) {
                            if (field == null || field.getValue() == null) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_CONDITIONAL_HELP_FEATURE, "Die Bedingung f\u00fcr die Angabe des Hilfsmerkmals ist erf\u00fcllt, so dass das Hilfsmerkmal angegeben werden muss.", helpFeature.getName(), field != null ? field.getContext() : null, condition.getBedingung(), null));
                            }
                        } else if (2 == condition.getBedingungsTyp() && field != null && field.getValue() != null) {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_CONDITIONAL_HELP_FEATURE, "Die Bedingung f\u00fcr die Angabe des Hilfsmerkmals ist nicht erf\u00fcllt, so dass das Hilfsmerkmal nicht angegeben werden darf.", helpFeature.getName(), field.getContext(), condition.getBedingung(), null));
                        }
                    } else {
                        this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.UNSUPPORTED_CONDITION_FORMAT, "Die verwendete Notationssprache f\u00fcr Bedingungen wird nicht unterst\u00fctzt.", helpFeature.getName(), null, condition.getBedingung(), null));
                    }
                }
                conditionFound = true;
            }
            if (field == null || field.getValue() == null) {
                if (!conditionFound && 3 != feldReferenz.getAttributRequired()) {
                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_HELP_FEATURE, "Das Hilfsmerkmal muss angegeben werden.", helpFeature.getName(), field != null ? field.getContext() : null, null, null));
                }
            } else {
                boolean isRequiredHelpFeature = !conditionFound && 3 != feldReferenz.getAttributRequired() || conditionFound && conditionFulfilled;
                DataInspector.this.checkFeatureValue(helpFeature, field, true, isRequiredHelpFeature, this.context, this.problemList);
            }
        }
    }

    private class RecordInspector
    extends FeaturesVisitor {
        private List<DataInspectionProblem> problemList;
        private InterpreterContext context;
        private FieldGroup currentDataset;
        private Stack<Integer> indices;

        private RecordInspector() {
        }

        private void check(MetaSDFAusgabegruppe dataGroup, FieldGroup record, FieldGroup helpFeatures, List<DataInspectionProblem> problemList) {
            this.problemList = problemList;
            this.indices = new Stack();
            DataInspector.this.fieldDescriptorFactory.setCurrentOutputGroup(dataGroup);
            this.context = new InterpreterContext();
            this.context.setFieldDescriptorFactory((FieldDescriptorFactory)DataInspector.this.fieldDescriptorFactory);
            this.context.setClassificationFactory(DataInspector.this.classificationFactory);
            this.context.setSatz((SatzInterface)new PlausiDataset(record, helpFeatures));
            this.currentDataset = record;
            dataGroup.accept(this);
            DataInspector.this.fieldDescriptorFactory.setCurrentOutputGroup(null);
        }

        @Override
        public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
            if (feldReferenz.getKlasse() instanceof MetaSDFMerkmalsgruppe) {
                MetaSDFMerkmalsgruppe group = (MetaSDFMerkmalsgruppe)feldReferenz.getKlasse();
                List<FieldGroup> fieldGroupList = this.currentDataset.getFieldGroupList(group.getName());
                boolean finished = false;
                Iterator conditions = this.getDataGroup().getSDFBedingungen();
                while (!finished && conditions != null && conditions.hasNext()) {
                    MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                    if (!SDFUtil.getReferenceField(condition.getBezugsfeld()).equals(String.valueOf(this.getHierarchy()) + group.getName())) continue;
                    if (3 != condition.getBedingungsTyp()) {
                        if (condition.getSpecification() != null) {
                            boolean fulfilled = false;
                            try {
                                fulfilled = DataInspector.this.interpreter.execute(condition.getSpecification(), this.context).asBoolean();
                            }
                            catch (Exception e) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.SDF_FORMAT_ERROR, "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.", group.getName(), null, condition.getBedingung(), e));
                            }
                            if (fulfilled) {
                                if (fieldGroupList == null || fieldGroupList.isEmpty()) {
                                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_CONDITIONAL_FEATURE_GROUP, "Die Bedingung f\u00fcr die Angabe der Merkmalsgruppe ist erf\u00fcllt, so dass die Merkmalsgruppe angegeben werden muss.", group.getName(), this.currentDataset.getContext(), condition.getBedingung(), null));
                                }
                            } else if (2 == condition.getBedingungsTyp() && fieldGroupList != null && !fieldGroupList.isEmpty()) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_CONDITIONAL_FEATURE_GROUP, "Die Bedingung f\u00fcr die Angabe der Merkmalsgruppe ist nicht erf\u00fcllt, so dass die Merkmalsgruppe nicht angegeben werden darf.", group.getName(), fieldGroupList.get(0).getContext(), condition.getBedingung(), null));
                            }
                        } else {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.UNSUPPORTED_CONDITION_FORMAT, "Die verwendete Notationssprache f\u00fcr Bedingungen wird nicht unterst\u00fctzt.", group.getName(), null, condition.getBedingung(), null));
                        }
                    }
                    finished = true;
                }
                DataInspector.this.fieldDescriptorFactory.setCurrentStructure(this.getHierachyStack(), this.indices);
                int i = 0;
                while (!finished && i < this.getHierachyStack().size()) {
                    DataInspector.this.fieldDescriptorFactory.setCurrentStructureLevel(i);
                    MetaSDFMerkmalsgruppe featureGroup = (MetaSDFMerkmalsgruppe)this.getHierachyStack().get(i);
                    conditions = featureGroup.getSDFBedingungen();
                    while (!finished && conditions != null && conditions.hasNext()) {
                        MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                        if (!SDFUtil.getReferenceField(condition.getBezugsfeld()).equals(String.valueOf(this.getHierarchyFrom(featureGroup)) + group.getName())) continue;
                        if (3 != condition.getBedingungsTyp()) {
                            if (condition.getSpecification() != null) {
                                boolean fulfilled = false;
                                try {
                                    fulfilled = DataInspector.this.interpreter.execute(condition.getSpecification(), this.context).asBoolean();
                                }
                                catch (Exception e) {
                                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.SDF_FORMAT_ERROR, "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.", group.getName(), null, condition.getBedingung(), e));
                                }
                                if (fulfilled) {
                                    if (fieldGroupList == null || fieldGroupList.isEmpty()) {
                                        this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_CONDITIONAL_FEATURE_GROUP, "Die Bedingung f\u00fcr die Angabe der Merkmalsgruppe ist erf\u00fcllt, so dass die Merkmalsgruppe angegeben werden muss.", group.getName(), this.currentDataset.getContext(), condition.getBedingung(), null));
                                    }
                                } else if (2 == condition.getBedingungsTyp() && fieldGroupList != null && !fieldGroupList.isEmpty()) {
                                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_CONDITIONAL_FEATURE_GROUP, "Die Bedingung f\u00fcr die Angabe der Merkmalsgruppe ist nicht erf\u00fcllt, so dass die Merkmalsgruppe nicht angegeben werden darf.", group.getName(), fieldGroupList.get(0).getContext(), condition.getBedingung(), null));
                                }
                            } else {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.UNSUPPORTED_CONDITION_FORMAT, "Die verwendete Notationssprache f\u00fcr Bedingungen wird nicht unterst\u00fctzt.", group.getName(), null, condition.getBedingung(), null));
                            }
                        }
                        finished = true;
                    }
                    ++i;
                }
                if (!finished && 3 != feldReferenz.getAttributRequired() && (fieldGroupList == null || fieldGroupList.isEmpty())) {
                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_FEATURE_GROUP, "Die Merkmalsgruppe muss angegeben werden.", group.getName(), this.currentDataset.getContext(), null, null));
                }
                DataInspector.this.fieldDescriptorFactory.setCurrentStructure(null, null);
                if (fieldGroupList != null && !fieldGroupList.isEmpty()) {
                    int minOccurs = SDFUtil.getMinOccurs(feldReferenz.getMinimaleAnzahl());
                    int maxOccurs = SDFUtil.getMaxOccurs(feldReferenz.getMaximaleAnzahl());
                    if (minOccurs != -1 && fieldGroupList.size() < minOccurs) {
                        if (maxOccurs != -1 && minOccurs == maxOccurs) {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_FEATURE_GROUPS, "Von der Merkmalsgruppe m\u00fcssen genau " + minOccurs + " Instanzen angegeben werden.", group.getName(), this.currentDataset.getContext(), null, null));
                        } else {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_FEATURE_GROUPS, "Von der Merkmalsgruppe m\u00fcssen mindestens " + minOccurs + " Instanzen angegeben werden.", group.getName(), this.currentDataset.getContext(), null, null));
                        }
                    }
                    if (maxOccurs != -1 && fieldGroupList.size() > maxOccurs) {
                        if (minOccurs != -1 && minOccurs == maxOccurs) {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_FEATURE_GROUPS, "Von der Merkmalsgruppe m\u00fcssen genau " + maxOccurs + " Instanzen angegeben werden.", group.getName(), this.currentDataset.getContext(), null, null));
                        } else {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_NUMBER_OF_FEATURE_GROUPS, "Von der Merkmalsgruppe d\u00fcrfen h\u00f6chstens " + maxOccurs + " Instanzen angegeben werden.", group.getName(), this.currentDataset.getContext(), null, null));
                        }
                    }
                    FieldGroup previousDataset = this.currentDataset;
                    HashSet<String> indices = new HashSet<String>();
                    int i2 = 0;
                    while (i2 < fieldGroupList.size()) {
                        this.currentDataset = fieldGroupList.get(i2);
                        if (group.getIndex() == 3) {
                            Field indexField = this.currentDataset.getField(group.getIndexVariable());
                            if (indexField == null || indexField.getValue() == null || indexField.getValue().length() == 0) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_INDEX_FEATURE, "Das indexbildende Merkmal muss in der Merkmalsgruppe vorkommen und darf nicht leer sein.", group.getIndexVariable(), indexField != null ? indexField.getContext() : this.currentDataset.getContext(), null, null));
                            } else if (!SDFUtil.isNumeric(indexField.getValue())) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.INVALID_INDEX_FEATURE, "Der Wert des indexbildenden Merkmals muss numerisch sein.", group.getIndexVariable(), indexField.getContext(), null, null));
                            } else if (indices.contains(indexField.getValue())) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.DUPLICATE_INDEX_FEATURE, "Die Indizes einer Merkmalsgruppe m\u00fcssen alle verschieden sein.", group.getIndexVariable(), indexField.getContext(), null, null));
                            } else {
                                indices.add(indexField.getValue());
                            }
                        }
                        this.indices.push(new Integer(i2));
                        super.visitSDFFeldReferenz(feldReferenz);
                        this.indices.pop();
                        ++i2;
                    }
                    this.currentDataset = previousDataset;
                }
            } else {
                MetaCustomSDFMerkmal feature = (MetaCustomSDFMerkmal)feldReferenz.getKlasse();
                Field field = this.currentDataset.getField(feature.getName());
                boolean conditionFound = false;
                boolean conditionFulfilled = false;
                Iterator conditions = this.getDataGroup().getSDFBedingungen();
                while (!conditionFound && conditions != null && conditions.hasNext()) {
                    MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                    if (!SDFUtil.getReferenceField(condition.getBezugsfeld()).equals(String.valueOf(this.getHierarchy()) + feature.getName())) continue;
                    if (3 != condition.getBedingungsTyp()) {
                        if (condition.getSpecification() != null) {
                            try {
                                conditionFulfilled = DataInspector.this.interpreter.execute(condition.getSpecification(), this.context).asBoolean();
                            }
                            catch (Exception e) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.SDF_FORMAT_ERROR, "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.", feature.getName(), null, condition.getBedingung(), e));
                            }
                            if (conditionFulfilled) {
                                if (field == null || field.getValue() == null) {
                                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_CONDITIONAL_FEATURE, "Die Bedingung f\u00fcr die Angabe des Merkmals ist erf\u00fcllt, so dass das Merkmal angegeben werden muss.", feature.getName(), field != null ? field.getContext() : this.currentDataset.getContext(), condition.getBedingung(), null));
                                }
                            } else if (2 == condition.getBedingungsTyp() && field != null && field.getValue() != null) {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.ILLEGAL_CONDITIONAL_FEATURE, "Die Bedingung f\u00fcr die Angabe des Merkmals ist nicht erf\u00fcllt, so dass das Merkmal nicht angegeben werden darf.", feature.getName(), field.getContext(), condition.getBedingung(), null));
                            }
                        } else {
                            this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.UNSUPPORTED_CONDITION_FORMAT, "Die verwendete Notationssprache f\u00fcr Bedingungen wird nicht unterst\u00fctzt.", feature.getName(), null, condition.getBedingung(), null));
                        }
                    }
                    conditionFound = true;
                }
                DataInspector.this.fieldDescriptorFactory.setCurrentStructure(this.getHierachyStack(), this.indices);
                int i = 0;
                while (!conditionFound && i < this.getHierachyStack().size()) {
                    DataInspector.this.fieldDescriptorFactory.setCurrentStructureLevel(i);
                    MetaSDFMerkmalsgruppe featureGroup = (MetaSDFMerkmalsgruppe)this.getHierachyStack().get(i);
                    conditions = featureGroup.getSDFBedingungen();
                    while (!conditionFound && conditions != null && conditions.hasNext()) {
                        MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                        if (!SDFUtil.getReferenceField(condition.getBezugsfeld()).equals(String.valueOf(this.getHierarchyFrom(featureGroup)) + feature.getName())) continue;
                        if (3 != condition.getBedingungsTyp()) {
                            if (condition.getSpecification() != null) {
                                try {
                                    conditionFulfilled = DataInspector.this.interpreter.execute(condition.getSpecification(), this.context).asBoolean();
                                }
                                catch (Exception e) {
                                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.SDF_FORMAT_ERROR, "Das Format der Erhebungsbeschreibung ist kein g\u00fcltiges DatML/SDF.", feature.getName(), null, condition.getBedingung(), e));
                                }
                                if (conditionFulfilled) {
                                    if (field == null || field.getValue() == null) {
                                        this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_CONDITIONAL_FEATURE, "Die Bedingung f\u00fcr die Angabe des Merkmals ist erf\u00fcllt, so dass das Merkmal angegeben werden muss.", feature.getName(), field != null ? field.getContext() : this.currentDataset.getContext(), condition.getBedingung(), null));
                                    }
                                } else if (2 == condition.getBedingungsTyp() && field != null && field.getValue() != null) {
                                    this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_CONDITIONAL_FEATURE, "Die Bedingung f\u00fcr die Angabe des Merkmals ist nicht erf\u00fcllt, so dass das Merkmal nicht angegeben werden darf.", feature.getName(), field.getContext(), condition.getBedingung(), null));
                                }
                            } else {
                                this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.UNSUPPORTED_CONDITION_FORMAT, "Die verwendete Notationssprache f\u00fcr Bedingungen wird nicht unterst\u00fctzt.", feature.getName(), null, condition.getBedingung(), null));
                            }
                        }
                        conditionFound = true;
                    }
                    ++i;
                }
                DataInspector.this.fieldDescriptorFactory.setCurrentStructure(this.getHierachyStack(), this.indices);
                if (field == null || field.getValue() == null) {
                    if (!conditionFound && 3 != feldReferenz.getAttributRequired()) {
                        this.problemList.add(new DataInspectionProblem(DataInspectionProblem.Type.MISSING_FEATURE, "Das Merkmal muss angegeben werden.", feature.getName(), field != null ? field.getContext() : this.currentDataset.getContext(), null, null));
                    }
                } else {
                    boolean isRequiredFeature = !conditionFound && 3 != feldReferenz.getAttributRequired() || conditionFound && conditionFulfilled;
                    DataInspector.this.checkFeatureValue(feature, field, false, isRequiredFeature, this.context, this.problemList);
                }
                DataInspector.this.fieldDescriptorFactory.setCurrentStructure(null, null);
            }
        }
    }
}

