/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.OlapConnection;
import org.olap4j.metadata.Cube;
import org.saiku.olap.discover.OlapMetaExplorer;
import org.saiku.olap.dto.SaikuConnection;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimension;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.saiku.service.datasource.DatasourceService;
import org.saiku.service.util.exception.SaikuServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapDiscoverService
implements Serializable {
    private static final long serialVersionUID = 884682532600907574L;
    private DatasourceService datasourceService;
    private OlapMetaExplorer metaExplorer;

    public void setDatasourceService(DatasourceService ds) {
        this.datasourceService = ds;
        this.metaExplorer = new OlapMetaExplorer(ds.getConnectionManager());
    }

    public List<SaikuCube> getAllCubes() {
        return this.metaExplorer.getAllCubes();
    }

    public List<SaikuConnection> getAllConnections() throws SaikuServiceException {
        try {
            return this.metaExplorer.getAllConnections();
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot retrieve all connections", e);
        }
    }

    public List<SaikuConnection> getConnection(String connectionName) {
        ArrayList<SaikuConnection> connections = new ArrayList<SaikuConnection>();
        try {
            SaikuConnection c = this.metaExplorer.getConnection(connectionName);
            connections.add(c);
            return connections;
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot retrieve all connections", e);
        }
    }

    public void refreshAllConnections() throws SaikuServiceException {
        try {
            this.datasourceService.getConnectionManager().refreshAllConnections();
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot refresh all connections", e);
        }
    }

    public void refreshConnection(String name) throws SaikuServiceException {
        try {
            this.datasourceService.getConnectionManager().refreshConnection(name);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot refresh all connections", e);
        }
    }

    public Cube getNativeCube(SaikuCube cube) throws SaikuServiceException {
        try {
            return this.metaExplorer.getNativeCube(cube);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get native cube for cube ( " + cube + " )", e);
        }
    }

    public OlapConnection getNativeConnection(String name) throws SaikuServiceException {
        try {
            return this.metaExplorer.getNativeConnection(name);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get native connection for cube ( " + name + " )", e);
        }
    }

    public List<SaikuDimension> getAllDimensions(SaikuCube cube) throws SaikuServiceException {
        try {
            return this.metaExplorer.getAllDimensions(cube);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get all dimensions for cube ( " + cube + " )", e);
        }
    }

    public SaikuDimension getDimension(SaikuCube cube, String dimensionName) throws SaikuServiceException {
        try {
            return this.metaExplorer.getDimension(cube, dimensionName);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get dimension (" + dimensionName + " ) for cube ( " + cube + " )", e);
        }
    }

    public List<SaikuHierarchy> getAllHierarchies(SaikuCube cube) throws SaikuServiceException {
        try {
            return this.metaExplorer.getAllHierarchies(cube);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get all hierarchies for cube ( " + cube + " )", e);
        }
    }

    public List<SaikuHierarchy> getAllDimensionHierarchies(SaikuCube cube, String dimensionName) {
        try {
            SaikuDimension dim = this.metaExplorer.getDimension(cube, dimensionName);
            if (dim == null) {
                throw new SaikuServiceException("Cannot find dimension ( " + dimensionName + ") for cube ( " + cube + " )");
            }
            return dim.getHierarchies();
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get all hierarchies for cube ( " + cube + " ) dimension ( " + dimensionName + " )", e);
        }
    }

    public List<SaikuLevel> getAllHierarchyLevels(SaikuCube cube, String dimensionName, String hierarchyName) {
        try {
            return this.metaExplorer.getAllLevels(cube, dimensionName, hierarchyName);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get all levels for cube ( " + cube + " ) dimension ( " + dimensionName + " ) hierarchy ( " + hierarchyName + " )", e);
        }
    }

    public List<SaikuMember> getLevelMembers(SaikuCube cube, String dimensionName, String hierarchyName, String levelName) {
        try {
            return this.metaExplorer.getAllMembers(cube, dimensionName, hierarchyName, levelName);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get all members for cube ( " + cube + " ) dimension ( " + dimensionName + " ) hierarchy ( " + hierarchyName + " )", e);
        }
    }

    public List<SaikuMember> getMeasures(SaikuCube cube) {
        try {
            return this.metaExplorer.getAllMeasures(cube);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get all measures for cube ( " + cube + " )", e);
        }
    }

    public List<SaikuMember> getHierarchyRootMembers(SaikuCube cube, String hierarchyName) {
        try {
            return this.metaExplorer.getHierarchyRootMembers(cube, hierarchyName);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException(e);
        }
    }

    public List<SaikuMember> getMemberChildren(SaikuCube cube, String uniqueMemberName) {
        try {
            return this.metaExplorer.getMemberChildren(cube, uniqueMemberName);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException(e);
        }
    }

    public SaikuMember getMember(SaikuCube cube, String uniqueMemberName) {
        try {
            return this.metaExplorer.getMember(cube, uniqueMemberName);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException(e);
        }
    }
}

