/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util;

import org.olap4j.CellSet;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.Matrix;
import org.saiku.olap.util.formatter.HierarchicalCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;

public class OlapResultSetUtil {
    public static CellDataSet cellSet2Matrix(CellSet cellSet) {
        HierarchicalCellSetFormatter formatter = new HierarchicalCellSetFormatter();
        return OlapResultSetUtil.cellSet2Matrix(cellSet, formatter);
    }

    public static CellDataSet cellSet2Matrix(CellSet cellSet, ICellSetFormatter formatter) {
        if (cellSet == null) {
            return new CellDataSet(0, 0);
        }
        Matrix matrix = formatter.format(cellSet);
        CellDataSet cds = new CellDataSet(matrix.getMatrixWidth(), matrix.getMatrixHeight());
        int z = 0;
        AbstractBaseCell[][] bodyvalues = new AbstractBaseCell[matrix.getMatrixHeight() - matrix.getOffset()][matrix.getMatrixWidth()];
        for (int y = matrix.getOffset(); y < matrix.getMatrixHeight(); ++y) {
            for (int x = 0; x < matrix.getMatrixWidth(); ++x) {
                bodyvalues[z][x] = matrix.get(x, y);
            }
            ++z;
        }
        cds.setCellSetBody(bodyvalues);
        AbstractBaseCell[][] headervalues = new AbstractBaseCell[matrix.getOffset()][matrix.getMatrixWidth()];
        for (int y = 0; y < matrix.getOffset(); ++y) {
            for (int x = 0; x < matrix.getMatrixWidth(); ++x) {
                headervalues[y][x] = matrix.get(x, y);
            }
        }
        cds.setCellSetHeaders(headervalues);
        cds.setOffset(matrix.getOffset());
        return cds;
    }
}

