/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.search;

import de.statspez.pleditor.ui.search.NotificationTextHandler;
import de.statspez.pleditor.ui.search.WordPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchUtil {
    private boolean caseSensitive;
    private int actualPos;
    private boolean fullWord;
    private List notificationHandler = new ArrayList();

    public void addNotificationHandler(NotificationTextHandler handler) {
        this.notificationHandler.add(handler);
    }

    public void removeNotificationHandler(NotificationTextHandler handler) {
        this.notificationHandler.remove(handler);
    }

    public WordPosition search(String searchString, String text) {
        String preparedSearchString = null;
        String preparedText = null;
        WordPosition position = new WordPosition();
        if (searchString.equals("")) {
            return position;
        }
        if (!this.isCaseSensitive()) {
            preparedSearchString = searchString.toLowerCase();
            preparedText = text.toLowerCase();
        } else {
            preparedSearchString = new String(searchString);
            preparedText = new String(text);
        }
        if (preparedSearchString.length() <= preparedText.length() && preparedText.indexOf(preparedSearchString) > -1) {
            if (this.getActualPos() + preparedSearchString.length() > preparedText.length()) {
                this.setActualPos(0);
            }
            position.setStart(this.getActualPos());
            int i = 0;
            while (i < 2) {
                String subString = preparedText.substring(position.getStart(), preparedSearchString.length() + position.getStart());
                if (subString.equals(preparedSearchString)) {
                    char preChar = ' ';
                    char afterChar = ' ';
                    if (this.isFullWord()) {
                        if (position.getStart() > 0) {
                            preChar = preparedText.charAt(position.getStart() - 1);
                        }
                        if (position.getStart() + preparedSearchString.length() < preparedText.length() - 1) {
                            afterChar = preparedText.charAt(position.getStart() + preparedSearchString.length());
                        }
                    }
                    if (Character.isWhitespace(preChar) && Character.isWhitespace(afterChar)) {
                        position.setFound(true);
                        this.setActualPos(this.getActualPos() + 1);
                        return position;
                    }
                }
                if (this.getActualPos() + preparedSearchString.length() >= preparedText.length()) {
                    this.setActualPos(0);
                    ++i;
                } else {
                    this.setActualPos(this.getActualPos() + 1);
                }
                position.setStart(this.getActualPos());
            }
        }
        return position;
    }

    public String replaceAll(String searchedString, String replacement, String text) {
        int i = 0;
        StringBuffer result = new StringBuffer();
        String regExpEscape = this.regExpEscape(searchedString);
        if (this.fullWord && regExpEscape.trim().length() > 1) {
            regExpEscape = "\\b" + regExpEscape + "\\b";
        }
        Pattern compile = !this.caseSensitive ? Pattern.compile(regExpEscape, 2) : Pattern.compile(regExpEscape);
        Matcher matcher = compile.matcher(text);
        while (matcher.find()) {
            ++i;
        }
        matcher.reset();
        result.append(matcher.replaceAll(this.regReplacement(replacement)));
        String notificationText = "Es wurde keine Ersetzung gemacht";
        if (i == 1) {
            notificationText = "Es wurde eine Ersetzung gemacht";
        } else if (i > 1) {
            notificationText = "Es wurden " + i + " Ersetzungen gemacht";
        }
        this.notifiy(notificationText);
        return result.toString();
    }

    private String regExpEscape(String s) {
        StringBuffer result = new StringBuffer(s.length() * 2);
        int i = 0;
        int len = s.length();
        while (i < len) {
            char character = s.charAt(i);
            if (character == '.' || character == '*' || character == '+' || character == '?' || character == '^' || character == '$' || character == '{' || character == '}' || character == '(' || character == ')' || character == '|' || character == '[' || character == ']' || character == '\\') {
                result.append('\\');
                result.append(character);
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    private String regReplacement(String s) {
        StringBuffer result = new StringBuffer(s.length() * 2);
        int i = 0;
        int len = s.length();
        while (i < len) {
            char character = s.charAt(i);
            if (character == '$' || character == '\\') {
                result.append('\\');
                result.append(character);
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    public String replace(WordPosition replacePosition, String searchedString, String replacement, String text) {
        String result = new String(text);
        if (replacePosition != null && replacePosition.isFound()) {
            result = String.valueOf(result.substring(0, replacePosition.getStart())) + replacement + result.substring(replacePosition.getStart() + searchedString.length(), result.length());
            this.setActualPos(replacePosition.getStart() + replacement.length());
        }
        return result;
    }

    private void notifiy(String text) {
        int i = 0;
        while (i < this.notificationHandler.size()) {
            NotificationTextHandler handler = (NotificationTextHandler)this.notificationHandler.get(i);
            handler.notify(text);
            ++i;
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setActualPos(int actualPos) {
        this.actualPos = actualPos;
    }

    public int getActualPos() {
        return this.actualPos;
    }

    public void setFullWord(boolean fullWord) {
        this.fullWord = fullWord;
    }

    public boolean isFullWord() {
        return this.fullWord;
    }
}

