/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.search;

import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class SatzInterfaceSearch
extends AbstractElementVisitor {
    private SatzInterface satz;
    private String searchString;
    private boolean caseSensitive;
    boolean regularExpression = false;
    boolean wholeWord = false;
    private List result;
    private TBFieldDescriptorFactory fieldDescriptorFactory;
    private FeldDeskriptorImpl currentFeldDeskriptor;

    public synchronized FeldDeskriptorInterface[] search(MetaCustomPlausibilisierung plausi, SatzInterface satz, String searchString, boolean caseSensitive, boolean regularExpression, boolean wholeWord) {
        this.satz = satz;
        this.searchString = searchString;
        this.caseSensitive = caseSensitive;
        this.regularExpression = regularExpression;
        this.wholeWord = wholeWord;
        this.result = new ArrayList();
        this.fieldDescriptorFactory = new TBFieldDescriptorFactory(plausi);
        this.currentFeldDeskriptor = null;
        plausi.rootThemenbereich().accept(this);
        return this.result.toArray(new FeldDeskriptorInterface[this.result.size()]);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        this.visitElements(tb.getFelder());
    }

    private void handleDimension(FeldDeskriptorImpl parentFeldDeskriptor, MetaTBFeld feld, int[] dimensions, int[] indices) {
        try {
            int size;
            FeldDeskriptorImpl feldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), null, parentFeldDeskriptor);
            int numOfDimension = 0;
            if (indices != null) {
                numOfDimension = indices.length;
            }
            if ((size = dimensions[numOfDimension]) < 0) {
                size = this.satz.getLaenge(feldDeskriptor, indices);
            }
            int i = 0;
            while (i < size) {
                int[] currentIndices = new int[numOfDimension + 1];
                if (numOfDimension > 0) {
                    int j = 0;
                    while (j < indices.length) {
                        currentIndices[j] = indices[j];
                        ++j;
                    }
                }
                currentIndices[currentIndices.length - 1] = i;
                this.currentFeldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), currentIndices, parentFeldDeskriptor);
                if (currentIndices.length == dimensions.length) {
                    feld.getKlasse().accept(this);
                } else {
                    this.handleDimension(parentFeldDeskriptor, feld, dimensions, currentIndices);
                }
                ++i;
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        FeldDeskriptorImpl previousFeldDeskriptor = this.currentFeldDeskriptor;
        int[] dimensions = ((MetaCustomTBFeld)feld).dimensions();
        if (dimensions != null && dimensions.length > 0) {
            this.handleDimension(previousFeldDeskriptor, feld, dimensions, null);
        } else {
            try {
                this.currentFeldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), null, previousFeldDeskriptor);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            feld.getKlasse().accept(this);
        }
        this.currentFeldDeskriptor = previousFeldDeskriptor;
    }

    @Override
    public void visitMerkmal(MetaMerkmal merkmal) {
        try {
            Value value = this.currentFeldDeskriptor.getValueFrom(this.satz);
            if (value != null && this.matches(value.asString())) {
                this.result.add(this.currentFeldDeskriptor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean matches(String value) {
        String searchStringConverted;
        String valueConverted;
        boolean find = false;
        if (this.caseSensitive) {
            valueConverted = value;
            searchStringConverted = this.searchString;
        } else {
            valueConverted = value.toLowerCase();
            searchStringConverted = this.searchString.toLowerCase();
        }
        boolean done = false;
        int lastIndex = 0;
        while (!done) {
            int index = valueConverted.indexOf(searchStringConverted, lastIndex);
            if (index < 0) {
                done = true;
                continue;
            }
            if (this.wholeWord) {
                char preChar = ' ';
                char postChar = ' ';
                if (index == 0) {
                    if (valueConverted.length() > index + searchStringConverted.length()) {
                        postChar = valueConverted.charAt(index + searchStringConverted.length());
                    }
                } else {
                    preChar = valueConverted.charAt(index - 1);
                    if (valueConverted.length() > index + searchStringConverted.length()) {
                        postChar = valueConverted.charAt(index + searchStringConverted.length());
                    }
                }
                if (Character.isWhitespace(preChar) && Character.isWhitespace(postChar)) {
                    find = true;
                }
                done = true;
                continue;
            }
            find = true;
            done = true;
        }
        return find;
    }
}

