/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AuspraegungParser
extends SubParser
implements SuperParser {
    private MetaCustomAuspraegung currentAuspraegung = null;
    private ParserChain parserChain = new ParserChain();
    private AuspraegungParser auspraegungParser;

    public AuspraegungParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "classificationElement".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("classificationElement".equalsIgnoreCase(localName)) {
            if (this.isEnabled()) {
                if (this.auspraegungParser == null) {
                    this.auspraegungParser = new AuspraegungParser(this, this.resolver());
                    this.parserChain = new ParserChain();
                    this.parserChain.addParser(this.auspraegungParser);
                }
                if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
                    throw ILParseException.unknownTagException(localName);
                }
            } else {
                this.enable();
                this.currentAuspraegung = new MetaCustomAuspraegung();
            }
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentAuspraegung;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.auspraegungParser) {
            MetaCustomAuspraegung aAuspraegung = (MetaCustomAuspraegung)this.auspraegungParser.object();
            this.currentAuspraegung.addToAuspraegungen(aAuspraegung);
            aAuspraegung.setParent(this.currentAuspraegung);
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("classificationCode".equalsIgnoreCase(localName)) {
            this.currentAuspraegung.setFachschluessel(chars);
            this.currentAuspraegung.setKode(chars);
            this.currentAuspraegung.setKodeSpezifikation(Helper.metaStructureFor(new DefaultMessageContext("Auspr\u00e4gung " + this.currentAuspraegung.getName()), this.convertToMetaProgramString(chars)));
        } else if ("classificationValue".equalsIgnoreCase(localName)) {
            this.currentAuspraegung.setName(chars);
        } else if ("classificationText".equalsIgnoreCase(localName)) {
            this.currentAuspraegung.setLangtext(chars);
        } else if ("classificationTextShort".equalsIgnoreCase(localName)) {
            this.currentAuspraegung.setKurztext(chars);
        } else if ("classificationElement".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "classificationCode".equalsIgnoreCase(tag) || "classificationValue".equalsIgnoreCase(tag) || "classificationText".equalsIgnoreCase(tag) || "classificationTextShort".equalsIgnoreCase(tag);
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    private String convertToMetaProgramString(String classiCode) {
        if (classiCode.indexOf(39) < 0 && classiCode.indexOf(44) < 0 && classiCode.indexOf("++") < 0 && classiCode.indexOf("+-") < 0 && classiCode.indexOf("-+") < 0 && classiCode.indexOf("--") < 0) {
            try {
                Double.parseDouble(classiCode);
            }
            catch (NumberFormatException e) {
                classiCode = "'" + classiCode + "'";
            }
        }
        classiCode = "myVal := {" + classiCode + "}";
        return classiCode;
    }
}

