/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import de.statspez.pleditor.generator.compare2.pdf.ITextUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Stack;

public abstract class ITextElementGenerator {
    public static float DEFAULT_SECTION_INDENTATION = 10.0f;
    public static float DEFAULT_SPACING_BEFORE = 5.0f;
    public static float DEFAULT_MARGIN = 24.0f;
    public static final float FIXED_LEADING = 1.0f;
    public static final float MILTIPLED_LEADING = 1.0f;
    public static final int POS_DEFAULT = 0;
    public static final int POS_SUP = 1;
    public static final int POS_SUB = 2;
    protected Document document;
    private Rectangle pageSize = PageSize.A4;
    private float marginLeft = DEFAULT_MARGIN * 1.5f;
    private float marginRight = DEFAULT_MARGIN;
    private float marginTop = DEFAULT_MARGIN;
    private float marginBottom = DEFAULT_MARGIN;
    private Stack textElementArrays = new Stack();

    public TextElementArray peekElementArrays() {
        return (TextElementArray)this.textElementArrays.peek();
    }

    public Element popElementArrays() {
        return (TextElementArray)this.textElementArrays.pop();
    }

    public TextElementArray pushElementArrays(TextElementArray item) {
        return this.textElementArrays.push(item);
    }

    public int sizeOfElementArrays() {
        return this.textElementArrays.size();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    protected void writeChunkToCurrentElementArray(String text, Font awtFont, Color color, Color background, int textPosition) {
        this.writeChunkToCurrentElementArray(text, awtFont, color, background, textPosition, false);
    }

    protected void writeChunkToCurrentElementArray(String text, Font awtFont, Color color, Color background) {
        this.writeChunkToCurrentElementArray(text, awtFont, color, background, 0, false);
    }

    protected void writeChunkToCurrentElementArray(String text, Font awtFont, Color color, Color background, int textPosition, boolean underline) {
        assert (this.textElementArrays.size() > 0) : "writeChunkToCurrentElementArray: Kein Element-Array verfuegbar.";
        this.peekElementArrays().add((Object)this.createChunk(text, awtFont, color, background, textPosition, underline));
    }

    protected Chunk createChunk(String text, Font awtFont, Color color, Color background, int textPosition, boolean underline) {
        com.lowagie.text.Font font;
        if (color == null) {
            color = Color.BLACK;
        }
        if (awtFont == null) {
            font = new com.lowagie.text.Font(0, 12.0f, 2);
            font.setColor(color);
        } else {
            font = ITextUtil.awtToITextFont(awtFont, color);
        }
        if (textPosition != 0) {
            font.setSize(font.getSize() * 2.0f / 3.0f);
        }
        Chunk chunk = new Chunk(text, font);
        if (background != null) {
            chunk.setBackground(background);
        }
        if (underline) {
            chunk.setUnderline(1.0f, -2.0f);
        }
        switch (textPosition) {
            case 1: {
                chunk.setTextRise(font.getSize());
                break;
            }
            case 2: {
                chunk.setTextRise(-font.getSize() / 2.0f);
                break;
            }
            default: {
                chunk.setTextRise(0.0f);
            }
        }
        return chunk;
    }

    protected void writeChunkToCurrentElementArray(String text) {
        this.writeChunkToCurrentElementArray(text, null, null, null, 0, false);
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }
}

