/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class UnionFunDef
extends FunDefBase {
    static final String[] ReservedWords = new String[]{"ALL", "DISTINCT"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Union", "Union(<Set1>, <Set2>[, ALL])", "Returns the union of two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}, UnionFunDef.class, ReservedWords);

    public UnionFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        String allString = UnionFunDef.getLiteralArg(call, 2, "DISTINCT", ReservedWords);
        final boolean all = allString.equalsIgnoreCase("ALL");
        UnionFunDef.checkCompatible(call.getArg(0), call.getArg(1), null);
        final ListCalc listCalc0 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc1 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList list0 = listCalc0.evaluateList(evaluator);
                TupleList list1 = listCalc1.evaluateList(evaluator);
                return UnionFunDef.this.union(list0, list1, all);
            }
        };
    }

    TupleList union(TupleList list0, TupleList list1, boolean all) {
        assert (list0 != null);
        assert (list1 != null);
        if (all) {
            if (list0.isEmpty()) {
                return list1;
            }
            if (list1.isEmpty()) {
                return list0;
            }
            TupleList result = TupleCollections.createList(list0.getArity());
            result.addAll(list0);
            result.addAll(list1);
            return result;
        }
        HashSet<List<Member>> added = new HashSet<List<Member>>();
        TupleList result = TupleCollections.createList(list0.getArity());
        FunUtil.addUnique(result, list0, added);
        FunUtil.addUnique(result, list1, added);
        return result;
    }
}

