/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.operators.PostfixOperator;
import org.pentaho.reporting.libraries.formula.operators.PrefixOperator;

public class DefaultOperatorFactory
implements OperatorFactory {
    private static final String INFIX_PREFIX = "org.pentaho.reporting.libraries.formula.operators.infix.";
    private static final String PREFIX_PREFIX = "org.pentaho.reporting.libraries.formula.operators.prefix.";
    private static final String POSTFIX_PREFIX = "org.pentaho.reporting.libraries.formula.operators.postfix.";
    private HashMap<String, InfixOperator> infixOperators = new HashMap();
    private HashMap<String, PrefixOperator> prefixOperators = new HashMap();
    private HashMap<String, PostfixOperator> postfixOperators = new HashMap();

    @Override
    public void initalize(Configuration configuration) {
        this.loadInfixOperators(configuration);
        this.loadPrefixOperators(configuration);
        this.loadPostfixOperators(configuration);
    }

    private void loadInfixOperators(Configuration configuration) {
        Iterator infixKeys = configuration.findPropertyKeys(INFIX_PREFIX);
        while (infixKeys.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)infixKeys.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            String tokenTrimmed = token.trim();
            InfixOperator operator = (InfixOperator)ObjectUtilities.loadAndInstantiate((String)operatorClass, DefaultOperatorFactory.class, InfixOperator.class);
            if (operator == null) continue;
            this.infixOperators.put(tokenTrimmed, operator);
        }
    }

    private void loadPrefixOperators(Configuration configuration) {
        Iterator infixKeys = configuration.findPropertyKeys(PREFIX_PREFIX);
        while (infixKeys.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)infixKeys.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            String tokenTrimmed = token.trim();
            PrefixOperator operator = (PrefixOperator)ObjectUtilities.loadAndInstantiate((String)operatorClass, DefaultOperatorFactory.class, PrefixOperator.class);
            if (operator == null) continue;
            this.prefixOperators.put(tokenTrimmed, operator);
        }
    }

    private void loadPostfixOperators(Configuration configuration) {
        Iterator infixKeys = configuration.findPropertyKeys(POSTFIX_PREFIX);
        while (infixKeys.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)infixKeys.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            String tokenTrimmed = token.trim();
            PostfixOperator operator = (PostfixOperator)ObjectUtilities.loadAndInstantiate((String)operatorClass, DefaultOperatorFactory.class, PostfixOperator.class);
            if (operator == null) continue;
            this.postfixOperators.put(tokenTrimmed, operator);
        }
    }

    @Override
    public InfixOperator createInfixOperator(String operator) {
        return this.infixOperators.get(operator);
    }

    @Override
    public PostfixOperator createPostfixOperator(String operator) {
        return this.postfixOperators.get(operator);
    }

    @Override
    public PrefixOperator createPrefixOperator(String operator) {
        return this.prefixOperators.get(operator);
    }
}

