/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class VarFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "VAR";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int i;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        double fSum = 0.0;
        double vSum = 0.0;
        double vMean = 0.0;
        double nValCount = 0.0;
        double[] values = new double[parameterCount];
        for (i = 0; i < parameterCount; ++i) {
            Type type1 = parameters.getType(i);
            Object value1 = parameters.getValue(i);
            Number result = context.getTypeRegistry().convertToNumber(type1, value1);
            if (result == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            double d = result.doubleValue();
            fSum += d;
            values[i] = d;
            nValCount += 1.0;
        }
        vMean = fSum / nValCount;
        i = 0;
        while ((double)i < nValCount) {
            vSum += (values[i] - vMean) * (values[i] - vMean);
            ++i;
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(vSum / (nValCount - 1.0)));
    }
}

