/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import org.pentaho.di.i18n.BaseMessages;

public class KettleURLClassLoader
extends URLClassLoader {
    private static Class<?> PKG = KettleURLClassLoader.class;
    private String name;

    public KettleURLClassLoader(URL[] url, ClassLoader classLoader) {
        super(url, classLoader);
    }

    public KettleURLClassLoader(URL[] url, ClassLoader classLoader, String name) {
        this(url, classLoader);
        this.name = name;
    }

    public String toString() {
        return super.toString() + " : " + this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Class<?> loadClassFromThisLoader(String arg0, boolean arg1) throws ClassNotFoundException {
        Class<?> clz = null;
        clz = this.findLoadedClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        clz = this.findClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        return clz;
    }

    protected Class<?> loadClassFromParent(String arg0, boolean arg1) throws ClassNotFoundException {
        Class<?> clz = this.getParent().loadClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        throw new ClassNotFoundException("Could not find :" + arg0);
    }

    @Override
    protected synchronized Class<?> loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        try {
            return this.loadClassFromThisLoader(arg0, arg1);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return this.loadClassFromParent(arg0, arg1);
    }

    public Class<?> loadClass(String name, ProtectionDomain protectionDomain) {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded == null) {
            String newName = name.replace('.', '/');
            InputStream is = super.getResourceAsStream(newName);
            byte[] driverBytes = this.toBytes(is);
            loaded = super.defineClass(name, driverBytes, 0, driverBytes.length, protectionDomain);
        }
        return loaded;
    }

    private byte[] toBytes(InputStream is) {
        byte[] retval = new byte[]{};
        try {
            int a = is.available();
            while (a > 0) {
                int i;
                byte[] buffer = new byte[a];
                is.read(buffer);
                byte[] newretval = new byte[retval.length + a];
                for (i = 0; i < retval.length; ++i) {
                    newretval[i] = retval[i];
                }
                for (i = 0; i < a; ++i) {
                    newretval[retval.length + i] = buffer[i];
                }
                retval = newretval;
                a = is.available();
            }
            return retval;
        }
        catch (Exception e) {
            System.out.println(BaseMessages.getString(PKG, "KettleURLClassLoader.Exception.UnableToReadClass", new String[0]) + e.toString());
            return null;
        }
    }

    private static Object getFieldObject(Class<?> clazz, String name, Object obj) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(obj);
    }

    public void closeClassLoader() {
        block30: {
            HashSet<String> closedFiles = new HashSet<String>();
            try {
                Object obj = KettleURLClassLoader.getFieldObject(URLClassLoader.class, "ucp", this);
                ArrayList loaders = (ArrayList)KettleURLClassLoader.getFieldObject(obj.getClass(), "loaders", obj);
                for (Object ldr : loaders) {
                    try {
                        JarFile file = (JarFile)KettleURLClassLoader.getFieldObject(ldr.getClass(), "jar", ldr);
                        closedFiles.add(file.getName());
                        file.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Vector nativeLibArr = (Vector)KettleURLClassLoader.getFieldObject(ClassLoader.class, "nativeLibraries", this);
                for (Object lib : nativeLibArr) {
                    try {
                        Method fMethod = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                        fMethod.setAccessible(true);
                        fMethod.invoke(lib, new Object[0]);
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            HashMap uCache = null;
            HashMap fCache = null;
            try {
                Class<?> jarUrlConnClass = null;
                try {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    jarUrlConnClass = contextClassLoader.loadClass("sun.net.www.protocol.jar.JarURLConnection");
                }
                catch (Throwable skip) {
                    // empty catch block
                }
                if (jarUrlConnClass == null) {
                    jarUrlConnClass = Class.forName("sun.net.www.protocol.jar.JarURLConnection");
                }
                Class<?> factory = KettleURLClassLoader.getFieldObject(jarUrlConnClass, "factory", null).getClass();
                try {
                    fCache = (HashMap)KettleURLClassLoader.getFieldObject(factory, "fileCache", null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    uCache = (HashMap)KettleURLClassLoader.getFieldObject(factory, "urlCache", null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (uCache != null) {
                    Set set = null;
                    while (set == null) {
                        try {
                            set = ((HashMap)uCache.clone()).keySet();
                        }
                        catch (ConcurrentModificationException e) {}
                    }
                    for (Object file : set) {
                        JarFile jar;
                        if (!(file instanceof JarFile) || !closedFiles.contains((jar = (JarFile)file).getName())) continue;
                        try {
                            jar.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (fCache != null) {
                            fCache.remove(uCache.get(jar));
                        }
                        uCache.remove(jar);
                    }
                    break block30;
                }
                if (fCache == null) break block30;
                for (Object key : ((HashMap)fCache.clone()).keySet()) {
                    JarFile jar;
                    Object file = fCache.get(key);
                    if (!(file instanceof JarFile) || !closedFiles.contains((jar = (JarFile)file).getName())) continue;
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    fCache.remove(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }
}

