/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;

public class FillColumn
implements JRPropertiesHolder {
    private BaseColumn tableColumn;
    private int width;
    private List<FillColumn> subcolumns;
    private Integer colSpan;
    private JRPropertiesMap properties;

    public FillColumn(BaseColumn tableColumn, JRPropertiesMap properties) {
        this(tableColumn, tableColumn.getWidth(), null, properties);
    }

    public FillColumn(BaseColumn tableColumn, int width, List<FillColumn> subcolumns, JRPropertiesMap properties) {
        this.tableColumn = tableColumn;
        this.width = width;
        this.subcolumns = subcolumns;
        this.properties = properties;
    }

    public BaseColumn getTableColumn() {
        return this.tableColumn;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColSpan() {
        if (this.colSpan == null) {
            this.colSpan = 1;
            if (this.subcolumns != null && this.subcolumns.size() > 0) {
                this.colSpan = 0;
                for (FillColumn subcolumn : this.subcolumns) {
                    this.colSpan = this.colSpan + subcolumn.getColSpan();
                }
            }
        }
        return this.colSpan;
    }

    public List<FillColumn> getSubcolumns() {
        return this.subcolumns;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FillColumn)) {
            return false;
        }
        FillColumn col = (FillColumn)obj;
        return this.tableColumn == col.tableColumn && this.width == col.width && (this.subcolumns == null ? col.subcolumns == null : col.subcolumns != null && this.subcolumns.equals(col.subcolumns));
    }

    public int hashCode() {
        int hash = this.tableColumn.hashCode();
        hash = hash * 37 + this.width;
        hash = hash * 37 + (this.subcolumns == null ? 0 : this.subcolumns.hashCode());
        return hash;
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && this.properties.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.properties;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }
}

