/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.dbcp.DbcpException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.jocl.JOCLContentHandler;
import org.apache.commons.pool.ObjectPool;
import org.xml.sax.SAXException;

public class PoolingDriver
implements Driver {
    protected static HashMap _pools;
    private static boolean accessToUnderlyingConnectionAllowed;
    protected static String URL_PREFIX;
    protected static int URL_PREFIX_LEN;
    protected static int MAJOR_VERSION;
    protected static int MINOR_VERSION;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return accessToUnderlyingConnectionAllowed;
    }

    public static synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        accessToUnderlyingConnectionAllowed = bl;
    }

    public synchronized ObjectPool getPool(String string) {
        try {
            return this.getConnectionPool(string);
        }
        catch (Exception exception) {
            throw new DbcpException(exception);
        }
    }

    public synchronized ObjectPool getConnectionPool(String string) throws SQLException {
        ObjectPool objectPool = (ObjectPool)_pools.get(string);
        if (null == objectPool) {
            InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(string) + ".jocl");
            if (null != inputStream) {
                JOCLContentHandler jOCLContentHandler = null;
                try {
                    jOCLContentHandler = JOCLContentHandler.parse(inputStream);
                }
                catch (SAXException sAXException) {
                    throw new SQLNestedException("Could not parse configuration file", sAXException);
                }
                catch (IOException iOException) {
                    throw new SQLNestedException("Could not load configuration file", iOException);
                }
                if (jOCLContentHandler.getType(0).equals(class$java$lang$String == null ? (class$java$lang$String = PoolingDriver.class$("java.lang.String")) : class$java$lang$String)) {
                    objectPool = this.getPool((String)jOCLContentHandler.getValue(0));
                    if (null != objectPool) {
                        this.registerPool(string, objectPool);
                    }
                } else {
                    objectPool = ((PoolableConnectionFactory)jOCLContentHandler.getValue(0)).getPool();
                    if (null != objectPool) {
                        this.registerPool(string, objectPool);
                    }
                }
            } else {
                throw new SQLException("Configuration file not found");
            }
        }
        return objectPool;
    }

    public synchronized void registerPool(String string, ObjectPool objectPool) {
        _pools.put(string, objectPool);
    }

    public synchronized void closePool(String string) throws SQLException {
        ObjectPool objectPool = (ObjectPool)_pools.get(string);
        if (objectPool != null) {
            _pools.remove(string);
            try {
                objectPool.close();
            }
            catch (Exception exception) {
                throw new SQLNestedException("Error closing pool " + string, exception);
            }
        }
    }

    public synchronized String[] getPoolNames() throws SQLException {
        Set set = _pools.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            return string.startsWith(URL_PREFIX);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            ObjectPool objectPool = this.getConnectionPool(string.substring(URL_PREFIX_LEN));
            if (null == objectPool) {
                throw new SQLException("No pool found for " + string + ".");
            }
            try {
                Connection connection = (Connection)objectPool.borrowObject();
                if (connection != null) {
                    connection = new PoolGuardConnectionWrapper(objectPool, connection);
                }
                return connection;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLNestedException("Cannot get a connection, pool error: " + noSuchElementException.getMessage(), noSuchElementException);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot get a connection, general error: " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void invalidateConnection(Connection connection) throws SQLException {
        PoolGuardConnectionWrapper poolGuardConnectionWrapper;
        if (connection instanceof PoolGuardConnectionWrapper) {
            poolGuardConnectionWrapper = (PoolGuardConnectionWrapper)connection;
            ObjectPool objectPool = poolGuardConnectionWrapper.pool;
            Connection connection2 = poolGuardConnectionWrapper.delegate;
            try {
                objectPool.invalidateObject((Object)connection2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            throw new SQLException("Invalid connection class");
        }
        poolGuardConnectionWrapper.delegate = null;
    }

    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        _pools = new HashMap();
        accessToUnderlyingConnectionAllowed = false;
        URL_PREFIX = "jdbc:apache:commons:dbcp:";
        URL_PREFIX_LEN = URL_PREFIX.length();
        MAJOR_VERSION = 1;
        MINOR_VERSION = 0;
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        private ObjectPool pool;
        private Connection delegate;

        PoolGuardConnectionWrapper(ObjectPool objectPool, Connection connection) {
            super(connection);
            this.pool = objectPool;
            this.delegate = connection;
        }

        protected void checkOpen() throws SQLException {
            if (this.delegate == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        public void close() throws SQLException {
            this.checkOpen();
            this.delegate.close();
            this.delegate = null;
            super.setDelegate(null);
        }

        public boolean isClosed() throws SQLException {
            if (this.delegate == null) {
                return true;
            }
            return this.delegate.isClosed();
        }

        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this.delegate.clearWarnings();
        }

        public void commit() throws SQLException {
            this.checkOpen();
            this.delegate.commit();
        }

        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return this.delegate.createStatement();
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            this.checkOpen();
            return this.delegate.createStatement(n, n2);
        }

        public boolean equals(Object object) {
            if (this.delegate == null) {
                return false;
            }
            return this.delegate.equals(object);
        }

        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this.delegate.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this.delegate.getCatalog();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this.delegate.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this.delegate.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            this.checkOpen();
            return this.delegate.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this.delegate.getWarnings();
        }

        public int hashCode() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.hashCode();
        }

        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this.delegate.isReadOnly();
        }

        public String nativeSQL(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.nativeSQL(string);
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareCall(string);
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareCall(string, n, n2);
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareStatement(string);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareStatement(string, n, n2);
        }

        public void rollback() throws SQLException {
            this.checkOpen();
            this.delegate.rollback();
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setAutoCommit(bl);
        }

        public void setCatalog(String string) throws SQLException {
            this.checkOpen();
            this.delegate.setCatalog(string);
        }

        public void setReadOnly(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setReadOnly(bl);
        }

        public void setTransactionIsolation(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setTransactionIsolation(n);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.checkOpen();
            this.delegate.setTypeMap(map);
        }

        public String toString() {
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.toString();
        }

        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this.delegate.getHoldability();
        }

        public void setHoldability(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setHoldability(n);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint();
        }

        public Savepoint setSavepoint(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint(string);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.releaseSavepoint(savepoint);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.rollback(savepoint);
        }

        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return this.delegate.createStatement(n, n2, n3);
        }

        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareCall(string, n, n2, n3);
        }

        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareStatement(string, n);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareStatement(string, n, n2, n3);
        }

        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareStatement(string, nArray);
        }

        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            this.checkOpen();
            return this.delegate.prepareStatement(string, stringArray);
        }

        public Connection getDelegate() {
            if (PoolingDriver.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        public Connection getInnermostDelegate() {
            if (PoolingDriver.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

