/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.csvinspector;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.csvinspector.CsvInspectionProblem;
import de.destatis.core.csvinspector.CsvInspectionReporter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CsvInspectionReport {
    private final Date date;
    private final List<CsvInspectionProblem> problems;
    private final CsvInspectionReporter.ProblemCounter problemCounter;
    private final boolean dataInspectionUsed;
    private final boolean dataInspectionWithoutReportRejection;
    private final boolean unitIdVerificationUsed;
    private final int declnum;
    private final CsvInspectionReporter.DeclarationInfos declarationInfos;

    public CsvInspectionReport(Date date, List<CsvInspectionProblem> problems, CsvInspectionReporter.ProblemCounter problemCounter, boolean dataInspectionUsed, boolean dataInspectionWithoutReportRejection, boolean unitIdVerificationUsed, int declnum, CsvInspectionReporter.DeclarationInfos declarationInfos) {
        Contract.verify((problemCounter != null ? 1 : 0) != 0, (String)"ProblemCounter muss angegeben werden.");
        this.date = date != null ? date : new Date();
        this.problems = problems != null ? problems : new ArrayList<CsvInspectionProblem>(0);
        this.problemCounter = problemCounter;
        this.dataInspectionUsed = dataInspectionUsed;
        this.dataInspectionWithoutReportRejection = dataInspectionWithoutReportRejection;
        this.unitIdVerificationUsed = unitIdVerificationUsed;
        this.declnum = declnum;
        this.declarationInfos = declarationInfos;
    }

    public boolean isOk() {
        return this.getNumOfProblems(CsvInspectionProblem.ProblemClass.ERROR) + this.getNumOfProblems(CsvInspectionProblem.ProblemClass.FATAL) == 0;
    }

    public Date getInspectionDate() {
        return this.date;
    }

    public int getNumOfDeclarations() {
        return this.declnum;
    }

    public int getNumOfProblems() {
        return this.problemCounter.getProblemCount(-1, null);
    }

    public int getNumOfProblems(CsvInspectionProblem.ProblemClass problemClass) {
        return this.problemCounter.getProblemCount(-1, problemClass);
    }

    public int getNumOfProblems(int declno) {
        return this.problemCounter.getProblemCount(declno, null);
    }

    public int getNumOfProblems(int declno, CsvInspectionProblem.ProblemClass problemClass) {
        return this.problemCounter.getProblemCount(declno, problemClass);
    }

    public List<CsvInspectionProblem> getProblemList() {
        return Collections.unmodifiableList(this.problems);
    }

    public List<CsvInspectionProblem> getProblemList(CsvInspectionProblem.ProblemClass problemClass) {
        ArrayList<CsvInspectionProblem> problemsOfClass = new ArrayList<CsvInspectionProblem>();
        for (CsvInspectionProblem problem : this.problems) {
            if (problem.getProblemClass() != problemClass) continue;
            problemsOfClass.add(problem);
        }
        return Collections.unmodifiableList(problemsOfClass);
    }

    public boolean isDataInspectionUsed() {
        return this.dataInspectionUsed;
    }

    public boolean isDataInspectionWithoutReportRejection() {
        return this.dataInspectionWithoutReportRejection;
    }

    public boolean isUnitIdVerificationUsed() {
        return this.unitIdVerificationUsed;
    }

    public boolean isInvalidUnitId() {
        boolean result = false;
        for (int i = 1; i <= this.declnum; ++i) {
            CsvInspectionReporter.DeclarationInfo declarationInfo = this.declarationInfos.getDeclarationInfo(i);
            if (declarationInfo == null || !declarationInfo.isInvalidUnitId()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isInvalidUnitId(int declno) {
        CsvInspectionReporter.DeclarationInfo declarationInfo = this.declarationInfos.getDeclarationInfo(declno);
        boolean result = declarationInfo != null ? declarationInfo.isInvalidUnitId() : false;
        return result;
    }

    public boolean containsCollectorCorrections() {
        boolean result = false;
        for (int i = 1; i <= this.declnum; ++i) {
            CsvInspectionReporter.DeclarationInfo declarationInfo = this.declarationInfos.getDeclarationInfo(i);
            if (declarationInfo == null || declarationInfo.getCollectorCorrection() == null || declarationInfo.getCollectorCorrection().length() <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getCollectorCorrection() {
        String result = null;
        for (int i = 1; i <= this.declnum; ++i) {
            String collectionCorrection;
            CsvInspectionReporter.DeclarationInfo declarationInfo = this.declarationInfos.getDeclarationInfo(i);
            String string = collectionCorrection = declarationInfo != null ? declarationInfo.getCollectorCorrection() : null;
            if (i == 1) {
                result = declarationInfo != null ? declarationInfo.getCollectorCorrection() : null;
                continue;
            }
            if (!(result == null && collectionCorrection != null || result != null && collectionCorrection == null) && (result == null || collectionCorrection == null || result.equals(collectionCorrection))) continue;
            result = null;
            break;
        }
        return result;
    }

    public String getCollectorCorrection(int declno) {
        CsvInspectionReporter.DeclarationInfo declarationInfo = this.declarationInfos.getDeclarationInfo(declno);
        String result = declarationInfo != null ? declarationInfo.getCollectorCorrection() : null;
        return result;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        buffer.append("Zeitpunkt der Erstellung:       ");
        buffer.append(formatter.format(this.date));
        buffer.append(lineSeparator);
        buffer.append("Pr\u00fcfergebnis:                   ");
        if (this.isOk()) {
            buffer.append("ok");
        } else {
            buffer.append("fehlerhaft");
        }
        buffer.append(lineSeparator);
        buffer.append("Anzahl der gefundenen Probleme: ");
        buffer.append(this.getNumOfProblems());
        if (this.problems.size() > 0) {
            buffer.append(lineSeparator);
            buffer.append(lineSeparator);
            buffer.append("Problemliste:");
            buffer.append(lineSeparator);
            buffer.append("--------------------------------------------------------");
            for (int i = 0; i < this.problems.size(); ++i) {
                CsvInspectionProblem problem = this.problems.get(i);
                buffer.append(lineSeparator);
                buffer.append(problem);
                buffer.append(lineSeparator);
                buffer.append("--------------------------------------------------------");
            }
        }
        return buffer.toString();
    }
}

