/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger logger = Logger.getLogger(FileUtil.class);
    private static final String SERVLET_CONTEXT_RESOURCE_PATH = "META-INF/resources/";

    public static boolean checkChroot(String chroot, String filename) {
        if (chroot == null) {
            return true;
        }
        try {
            File file = new File(filename);
            String canonicalForFile = file.getCanonicalPath();
            File root = new File(chroot);
            String canonicalForRoot = root.getCanonicalPath();
            boolean res = canonicalForFile.startsWith(canonicalForRoot);
            if (!res) {
                logger.error((Object)("Zugriff auf Datei " + canonicalForFile + " ausserhalb des chroot " + chroot + " verweigert"), new Throwable());
            }
            return res;
        }
        catch (IOException e) {
            logger.error((Object)("Fehler beim Analysieren des Pfades \"" + filename + "\": "), (Throwable)e);
            return false;
        }
    }

    public static InputStream getFileFromFilesystemOrClasspath(String filename, String filesystemPrefix) {
        InputStream resourceStream;
        String pathname = filesystemPrefix + "/" + filename;
        if (new File(pathname).canRead()) {
            try {
                return new FileInputStream(pathname);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Cannot open file \"" + pathname + "\" although it exists and may be read"), (Throwable)e);
            }
        }
        if ((resourceStream = FileUtil.class.getClassLoader().getResourceAsStream(SERVLET_CONTEXT_RESOURCE_PATH + filename)) != null) {
            return resourceStream;
        }
        return FileUtil.class.getClassLoader().getResourceAsStream(filename);
    }
}

