/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.MDFiveHash;
import de.his.tools.RequestUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class QISSingleSignOnClientAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(QISSingleSignOnClientAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        String token = this.getToken(confElement, authProp, request);
        String user = this.checkToken(confElement, token);
        if (user != null) {
            userProp.put("userinfo", user);
            userProp.put("authenticated", "y");
        }
        return userProp;
    }

    String getToken(Element confElement, Properties authProp, HttpServletRequest request) {
        String token = authProp.getProperty("token");
        String cookieName = confElement.getAttributeValue("cookie");
        if (cookieName != null && !cookieName.trim().equals("")) {
            token = RequestUtil.getCookie(request, cookieName, token);
        }
        logger.debug((Object)("token=" + token));
        return token;
    }

    String checkToken(Element confElement, String token) {
        if (token != null && token.trim().length() > 0) {
            boolean valid;
            StringTokenizer st = new StringTokenizer(token, "/");
            String version = st.nextToken();
            String timeStr = st.nextToken();
            String service = st.nextToken();
            int posStart = version.length() + timeStr.length() + service.length() + 3;
            int posEnd = token.lastIndexOf("/");
            String user = token.substring(posStart, posEnd);
            String toHash = token.substring(0, posEnd);
            String hash = token.substring(posEnd + 1);
            long time = Long.parseLong(timeStr);
            boolean bl = valid = this.checkVersion(version) && this.checkService(service, confElement) && this.checkTime(time, confElement) && this.checkHash(version, hash, toHash, confElement);
            if (valid) {
                return user;
            }
        }
        return null;
    }

    boolean checkVersion(String version) {
        boolean retVal;
        boolean bl = retVal = version.startsWith("1.0") || version.startsWith("2.0");
        if (!retVal) {
            logger.error((Object)("Nicht unterstuetzte Version: " + version));
        }
        return retVal;
    }

    boolean checkService(String service, Element confElement) {
        boolean res = false;
        String myService = confElement.getChildText("service");
        if (myService != null && !myService.trim().equals("")) {
            res = myService.equals(service);
            if (!res) {
                logger.info((Object)("Unbekannter Service: " + service + " (my service: " + myService + ")"));
            }
        } else {
            logger.error((Object)"Kein \"service\" fuer QISSingleSignOnClientAuth in der LoginConf.xml definiert.");
        }
        return res;
    }

    boolean checkTime(long time, Element confElement) {
        long currentTime;
        long timeout;
        boolean res;
        String timeoutStr = confElement.getChildText("timeout");
        if (timeoutStr == null || timeoutStr.trim().equals("")) {
            logger.warn((Object)"Keine Zeitangabe in der LoginConf.xml");
            timeoutStr = "60";
        }
        boolean bl = res = time + (timeout = Long.parseLong(timeoutStr)) > (currentTime = System.currentTimeMillis() / 1000L);
        if (res) {
            boolean bl2 = res = time < currentTime + timeout;
            if (!res) {
                logger.warn((Object)("Erstellungszeit des Tokens liegt zu weit in der Zukunft. timeout: " + timeout + " Sekunden; aktuelle Zeit: " + currentTime));
            }
        } else {
            logger.warn((Object)("Erstellungszeit des Tokens liegt zu weit in der Vergangenheit.  timeout: " + timeout + " Sekunden; aktuelle Zeit: " + currentTime));
        }
        return res;
    }

    boolean checkHash(String version, String hash, String toHash, Element confElement) {
        String sharedSecret = confElement.getChildText("shared-secret");
        if (sharedSecret == null || sharedSecret.trim().equals("")) {
            logger.error((Object)"shared-secret ist nicht definiert");
            return false;
        }
        String myHash = null;
        if (version.startsWith("1.0")) {
            myHash = MDFiveHash.hash(toHash + "/" + sharedSecret);
        } else {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-512");
                md.update((toHash + "/" + sharedSecret).getBytes("UTF-8"));
                byte[] mb = md.digest();
                myHash = MDFiveHash.getHex(mb);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)e, (Throwable)e);
                return false;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e, (Throwable)e);
                return false;
            }
        }
        boolean retVal = myHash.equals(hash);
        if (!retVal) {
            logger.warn((Object)("Ungueltiges Auth-Token: Angegebener Hashwert und berechneter Hashwert stimmen nicht ueberein: " + hash + " (berechnet: " + myHash + ")"));
        }
        return retVal;
    }
}

