/*
 * Decompiled with CFR 0.152.
 */
package de.his.net;

import de.his.net.LineBasedSocket;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.mail.URLName;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class SimpleIMAPClient
extends LineBasedSocket {
    private static Logger logger = Logger.getLogger(SimpleIMAPClient.class);
    private final URLName url;
    private final String charset;

    public SimpleIMAPClient(URLName url, String charset) throws IOException {
        super(SimpleIMAPClient.createSocket(url.getProtocol(), url.getHost(), SimpleIMAPClient.getPort(url)), false, charset);
        this.url = url;
        this.charset = charset;
    }

    static int getPort(URLName url) {
        int port = url.getPort();
        if (port < 0) {
            String prot = url.getProtocol();
            port = prot.startsWith("imaps") ? 993 : (prot.startsWith("imap3") ? 220 : 143);
        }
        return port;
    }

    private static Socket createSocket(String protocol, String host, int port) throws IOException {
        if (protocol.equals("imaps")) {
            SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            return sslsocketfactory.createSocket(host, port);
        }
        if (protocol.startsWith("imap")) {
            SocketFactory socketfactory = SocketFactory.getDefault();
            return socketfactory.createSocket(host, port);
        }
        throw new MalformedURLException("Unknown protocol: " + protocol);
    }

    public void checkGreeting() throws IOException {
        String line = this.recvLine();
        if (line == null) {
            throw new IOException("Server closed stream before greeting");
        }
        if (!line.toLowerCase().startsWith("* ok ")) {
            throw new IOException("Server greeting expected but got " + line);
        }
    }

    public boolean login() throws IOException {
        this.loginSend();
        return this.loginCheckResponse();
    }

    public int getNumberOfUnreadMails() throws IOException {
        this.sendLine("2 status inbox (UNSEEN)");
        List<String> response = this.readMultilineIMAPResponse();
        int res = SimpleIMAPClient.extractNumberOfFlaggedMails(response, "UNSEEN");
        return res;
    }

    static int extractNumberOfFlaggedMails(List<String> response, String flag) {
        String flagLower = flag.toLowerCase(Locale.ENGLISH);
        int res = 0;
        for (String line : response) {
            int pos = line.toLowerCase(Locale.ENGLISH).indexOf(flagLower);
            if (pos <= -1) continue;
            int pos2 = line.indexOf(")", pos);
            String number = line.substring(pos + flag.length() + 1, pos2);
            res = Integer.parseInt(number);
        }
        return res;
    }

    private List<String> readMultilineIMAPResponse() throws IOException {
        LinkedList<String> res = new LinkedList<String>();
        String line = this.recvLine();
        while (line != null) {
            logger.debug((Object)line);
            res.add(line);
            if (!line.startsWith("* ")) break;
            line = this.recvLine();
        }
        return res;
    }

    private void loginSend() {
        String username = this.url.getUsername();
        String password = this.url.getPassword();
        try {
            this.sendLine("1 login " + username + " {" + password.getBytes(this.charset).length + "+}");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.sendLine(password);
    }

    private boolean loginCheckResponse() throws IOException {
        String line = this.recvLine();
        logger.debug((Object)line);
        if (line == null) {
            throw new IOException("Server closed the stream after sending loing information");
        }
        return line.toLowerCase().startsWith("1 ok ");
    }

    @Override
    public synchronized void close() throws IOException {
        this.sendLine("2 logout");
        this.recvLine();
        super.close();
    }
}

