/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.GetSDFMetaResourceRequest;
import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.ResponseToGetCommonResourceRequest;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.connect.UnsupportedProtocolException;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.Resource;
import de.destatis.core.resource.ResourceType;
import de.destatis.core.resource.SDFMetaResource;
import de.destatis.core.resource.util.CommonResourceId;
import de.destatis.core.resource.util.DatMlRawVersion;
import de.destatis.core.resource.util.GetResourceQuery;
import de.destatis.core.resource.util.ResourceResponse;
import java.util.Iterator;
import java.util.List;

public class GetSDFMetaResourceQuery
extends GetResourceQuery {
    private String datMlRawVersion;

    public GetSDFMetaResourceQuery(String datMlRawVersion) {
        super(ResourceType.TYPE_SDFMETA);
        this.datMlRawVersion = datMlRawVersion;
        if (this.datMlRawVersion != null && !DatMlRawVersion.isValidPrettyDatMlRawVersion(this.datMlRawVersion)) {
            throw new IllegalArgumentException("Ung\u00fcltige DatML/RAW-Version \u00fcbergeben.");
        }
    }

    @Override
    public ResourceResponse downloadRessource(Client client, String localResourceId) throws TransferProtocolException {
        ResponseToGetCommonResourceRequest response;
        GetSDFMetaResourceRequest request = new GetSDFMetaResourceRequest(this.datMlRawVersion, localResourceId);
        try {
            response = client.send(request);
        }
        catch (IncompleteRequestException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedProtocolException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && GetSDFMetaResourceQuery.class.equals(obj.getClass())) {
            GetSDFMetaResourceQuery other = (GetSDFMetaResourceQuery)obj;
            if (this.datMlRawVersion == null && other.datMlRawVersion == null) {
                equals = true;
            } else if (this.datMlRawVersion != null && this.datMlRawVersion.equals(other.datMlRawVersion)) {
                equals = true;
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = this.datMlRawVersion == null ? GetSDFMetaResourceQuery.class.hashCode() : this.datMlRawVersion.hashCode();
        return hashCode;
    }

    @Override
    public Object getQueryKey() {
        return this;
    }

    @Override
    public String getResourceId(List allResourceIds) throws NoResourceFoundException {
        String tmpResult;
        if (allResourceIds.size() > 0) {
            String datMlRawVersionResIdFormat = this.datMlRawVersion != null ? DatMlRawVersion.getDatMlRawVersionFromPrettyDatMlRawVersion(this.datMlRawVersion) : null;
            Iterator it = allResourceIds.iterator();
            tmpResult = null;
            String tmpVersion = null;
            while (it.hasNext()) {
                String currentResourceId = (String)it.next();
                if (this.datMlRawVersion == null) {
                    if (tmpResult == null) {
                        tmpResult = currentResourceId;
                        continue;
                    }
                    if (currentResourceId.compareTo(tmpResult) <= 0) continue;
                    tmpResult = currentResourceId;
                    continue;
                }
                String currentDatMlRawVersion = CommonResourceId.getDatMlRawVersion(currentResourceId);
                if (!currentDatMlRawVersion.equals(datMlRawVersionResIdFormat)) continue;
                String currentVersion = CommonResourceId.getVersion(currentResourceId);
                if (tmpResult == null) {
                    tmpResult = currentResourceId;
                    tmpVersion = currentVersion;
                    continue;
                }
                if (currentVersion.compareTo(tmpVersion) <= 0) continue;
                tmpResult = currentResourceId;
                tmpVersion = currentVersion;
            }
            if (tmpResult == null) {
                throw new NoResourceFoundException(0);
            }
        } else {
            throw new NoResourceFoundException(0);
        }
        String result = tmpResult;
        return result;
    }

    @Override
    public Resource createResource(String resourceId, byte[] resourceData) {
        return new SDFMetaResource(resourceId, resourceData);
    }
}

