/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.model;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.editor.util.BindedElementProvider;
import de.destatis.core.map.model.BindingInfo;
import de.destatis.core.map.model.BindingInfoAttribute;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.MetaMapping;
import de.destatis.core.map.model.SelectorBinding;
import de.destatis.core.resource.util.CommonResourceId;
import de.destatis.core.resource.util.DatMlRawVersion;
import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.SDFElement;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import de.statspez.sdf.generator.util.SDFUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class BindingHelper {
    public static final String PATH_SEPARATOR = ".";
    private static final Integer ZERO = new Integer(0);

    public static void clearHelpFeaturePositions(Mapping mapping) {
        Iterator iter = mapping.getBindings();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (!(binding instanceof HelpFeatureBinding)) continue;
            ((HelpFeatureBinding)binding).setPosition(null);
        }
    }

    public static void computePositions(MetaMapping metaMapping) {
        Iterator iter = metaMapping.getBindings();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (!(binding instanceof FieldSetBinding)) continue;
            FieldSetBinding fieldSetBinding = (FieldSetBinding)binding;
            BindingHelper.computePositions(fieldSetBinding, 1);
        }
    }

    public static void computePositions(Mapping mapping) {
        Binding binding;
        HelpFeatureConfigValue helpFeatureConfig = mapping.getHelpFeatureConfig();
        int position = 1;
        Iterator iter = mapping.getBindings();
        boolean selector = false;
        while (iter.hasNext()) {
            binding = (Binding)iter.next();
            if (binding instanceof HelpFeatureBinding) {
                Integer positionInteger;
                if (selector) {
                    throw new IllegalStateException("Hinter einem Selektor d\u00fcrfen keine Hilfsmerkmale stehen.");
                }
                if (!helpFeatureConfig.isDefaultValue()) {
                    positionInteger = new Integer(position);
                    ++position;
                } else {
                    positionInteger = null;
                }
                ((FieldBinding)binding).setPosition(positionInteger);
                continue;
            }
            if (!(binding instanceof SelectorBinding)) continue;
            if (!selector) {
                if (helpFeatureConfig.isSeparateRow()) {
                    position = 1;
                }
                selector = true;
            }
            ((SelectorBinding)binding).setPosition(new Integer(position));
            ++position;
        }
        if (!selector && helpFeatureConfig.isSeparateRow()) {
            position = 1;
        }
        iter = mapping.getBindings();
        while (iter.hasNext()) {
            binding = (Binding)iter.next();
            if (!(binding instanceof FieldSetBinding)) continue;
            FieldSetBinding fieldSetBinding = (FieldSetBinding)binding;
            BindingHelper.computePositions(fieldSetBinding, position);
        }
    }

    public static int computePositions(BindingGroup bindingGroup, int position) {
        Iterator iter = bindingGroup.getBindings();
        while (iter.hasNext()) {
            FieldGroupBinding fieldGroupBinding;
            Binding binding = (Binding)iter.next();
            if (binding instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)binding;
                fieldBinding.setPosition(new Integer(position));
                ++position;
                continue;
            }
            if (!(binding instanceof FieldGroupBinding) || (fieldGroupBinding = (FieldGroupBinding)binding).getSize() == null || fieldGroupBinding.getSize() <= 0) continue;
            position += (BindingHelper.computePositions(fieldGroupBinding, position) - position) * fieldGroupBinding.getSize();
        }
        return position;
    }

    public static final String getSubPathString(Binding binding, int startIndex, boolean usePrettyNames) {
        StringBuffer pathString = new StringBuffer();
        Binding[] path = binding.getPath();
        int len = path.length;
        int lenMinus1 = len - 1;
        for (int i = startIndex; i < len; ++i) {
            Binding pathElemement = path[i];
            String elementName = usePrettyNames ? pathElemement.getPrettyName() : pathElemement.getId();
            pathString.append(elementName);
            if (i >= lenMinus1) continue;
            pathString.append(PATH_SEPARATOR);
        }
        return pathString.toString();
    }

    public static String getPrettyNamePathString(Binding binding) {
        return BindingHelper.getSubPathString(binding, 0, true);
    }

    public static Binding getBindingById(BindingGroup bindingGroup, String id) {
        Binding result = null;
        Iterator it = bindingGroup.getBindings();
        while (it.hasNext()) {
            Binding check = (Binding)it.next();
            String checkId = check.getId();
            if (!checkId.equals(id)) continue;
            result = check;
            break;
        }
        return result;
    }

    public static Binding getBindingByIdStrict(BindingGroup bindingGroup, String id) {
        Binding result = BindingHelper.getBindingById(bindingGroup, id);
        if (result == null) {
            throw new IllegalStateException("Kein Binding mit ID '" + id + "' in BindingGroup '" + BindingHelper.getPrettyNamePathString(bindingGroup) + "' vorhanden.");
        }
        return result;
    }

    public static List getAllCountingHmmFieldBindingsSorted(Mapping mapping) {
        ArrayList result = new ArrayList();
        BindingHelper.addAllCountingHmmFieldBindings(mapping, result);
        BindingHelper.sortFieldBindingsByPosition(result);
        return result;
    }

    public static List getAllCountingFieldBindingsSorted(Mapping mapping, FieldSetBinding record) {
        HelpFeatureConfigValue helpFeatureConfig = mapping.getHelpFeatureConfig();
        ArrayList result = new ArrayList();
        if (helpFeatureConfig.isEachRecord()) {
            BindingHelper.addAllCountingHmmFieldBindings(mapping, result);
        }
        BindingHelper.addAllCountingSelectorFieldBindings(mapping, result);
        BindingHelper.addAllCountingFieldBindings(record, result);
        BindingHelper.sortFieldBindingsByPosition(result);
        return result;
    }

    public static List getAllCountingFieldBindingsSorted(FieldSetBinding fieldSet) {
        ArrayList result = new ArrayList();
        BindingHelper.addAllCountingFieldBindings(fieldSet, result);
        BindingHelper.sortFieldBindingsByPosition(result);
        return result;
    }

    private static void addAllCountingHmmFieldBindings(Mapping mapping, List targetList) {
        Iterator iter = mapping.getBindings();
        while (iter.hasNext()) {
            HelpFeatureBinding helpFeatureBinding;
            Binding binding = (Binding)iter.next();
            if (!(binding instanceof HelpFeatureBinding) || (helpFeatureBinding = (HelpFeatureBinding)binding).getPosition() == null || helpFeatureBinding.getPosition() <= 0) continue;
            targetList.add(binding);
        }
    }

    private static void addAllCountingSelectorFieldBindings(Mapping mapping, List targetList) {
        Iterator iter = mapping.getBindings();
        while (iter.hasNext()) {
            SelectorBinding selectorBinding;
            Binding binding = (Binding)iter.next();
            if (!(binding instanceof SelectorBinding) || (selectorBinding = (SelectorBinding)binding).getPosition() == null || selectorBinding.getPosition() <= 0) continue;
            targetList.add(binding);
        }
    }

    private static void addAllCountingFieldBindings(BindingGroup bindingGroup, List targetList) {
        Iterator iter = bindingGroup.getBindings();
        while (iter.hasNext()) {
            FieldGroupBinding fieldGroupBinding;
            Binding binding = (Binding)iter.next();
            if (binding instanceof FieldBinding) {
                if (((FieldBinding)binding).getPosition() == null) continue;
                targetList.add(binding);
                continue;
            }
            if (!(binding instanceof FieldGroupBinding) || (fieldGroupBinding = (FieldGroupBinding)binding).getSize() == null || fieldGroupBinding.getSize() <= 0) continue;
            BindingHelper.addAllCountingFieldBindings(fieldGroupBinding, targetList);
        }
    }

    private static void sortFieldBindingsByPosition(List fieldBindingList) {
        Collections.sort(fieldBindingList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((FieldBinding)o1).getPosition().compareTo(((FieldBinding)o2).getPosition());
            }
        });
    }

    public static Integer getLastCalculatedCsvPosition(FieldSetBinding fieldSetBinding) {
        int max = -1;
        Iterator it = fieldSetBinding.getBindings();
        while (it.hasNext()) {
            int tmp;
            MinAndMax minAndMax;
            Binding binding = (Binding)it.next();
            if (binding instanceof FieldBinding) {
                Integer position = ((FieldBinding)binding).getPosition();
                if (position == null || position <= max) continue;
                max = position;
                continue;
            }
            if (!(binding instanceof FieldGroupBinding) || (minAndMax = BindingHelper.getFirstAndLastCalculatedCsvPosition((FieldGroupBinding)binding)) == null || (tmp = minAndMax.getMax()) <= max) continue;
            max = tmp;
        }
        Integer result = null;
        if (max > 0) {
            result = new Integer(max);
        }
        return result;
    }

    public static MinAndMax getFirstAndLastCalculatedCsvPosition(FieldGroupBinding fieldGroupBinding) {
        MinAndMax result = BindingHelper.getMinAndMaxCsvPosition(fieldGroupBinding, null);
        if (result.getMin() == Integer.MAX_VALUE && result.getMax() == Integer.MIN_VALUE) {
            result = null;
        }
        return result;
    }

    public static MinAndMax getFirstAndLastCalculatedCsvPositionForFirstIndex(FieldGroupBinding fieldGroupBinding) {
        MinAndMax result = BindingHelper.getMinAndMaxCsvPosition(fieldGroupBinding, ZERO);
        if (result.getMin() == Integer.MAX_VALUE && result.getMax() == Integer.MIN_VALUE) {
            result = null;
        }
        return result;
    }

    public static Integer getOffset(FieldGroupBinding fieldGroupBinding) {
        Integer offset = null;
        MinAndMax minAndMax = BindingHelper.getFirstAndLastCalculatedCsvPositionForFirstIndex(fieldGroupBinding);
        offset = minAndMax != null ? new Integer(minAndMax.getMax() - minAndMax.getMin() + 1) : ZERO;
        return offset;
    }

    private static MinAndMax getMinAndMaxCsvPosition(FieldGroupBinding fieldGroupBinding, Integer index) {
        MinAndMax minAndMax = new MinAndMax();
        Integer quantity = fieldGroupBinding.getSize();
        if (quantity != null && quantity > 0) {
            Iterator it = fieldGroupBinding.getBindings();
            while (it.hasNext()) {
                Binding binding = (Binding)it.next();
                if (binding instanceof FieldBinding) {
                    Integer position = ((FieldBinding)binding).getPosition();
                    if (position == null) continue;
                    int pos = position;
                    minAndMax.update(pos);
                    continue;
                }
                if (!(binding instanceof FieldGroupBinding)) continue;
                MinAndMax subMinAndMax = BindingHelper.getMinAndMaxCsvPosition((FieldGroupBinding)binding, null);
                minAndMax.update(subMinAndMax);
            }
            int last = minAndMax.getMax();
            if (last != Integer.MIN_VALUE) {
                int len = index == null ? quantity : index + 1;
                int offset = (last - minAndMax.getMin() + 1) * (len - 1);
                minAndMax.update(last += offset);
            }
        }
        return minAndMax;
    }

    public static BindingInfo getBindingInfo(Binding binding, BindedElementProvider bindedElementProvider) {
        BindingInfo bindingInfo = new BindingInfo();
        bindingInfo.setName(binding.getId());
        if (binding instanceof Mapping) {
            bindingInfo.setType("Erhebung");
            MetaErhebungsbeschreibung surveyDefinition = (MetaErhebungsbeschreibung)bindedElementProvider.getBindedElement(binding);
            if (surveyDefinition.getBeschreibung() != null && surveyDefinition.getBeschreibung().length() > 0) {
                bindingInfo.setDescription(surveyDefinition.getBeschreibung());
            }
        } else if (binding instanceof MetaMapping) {
            bindingInfo.setType("Metadatenbeschreibung ");
            MetaSDFMetabeschreibung metaDefinition = (MetaSDFMetabeschreibung)bindedElementProvider.getBindedElement(binding);
            String resourceId = metaDefinition.getProzedurCode();
            String datMlRawVersionResId = CommonResourceId.getDatMlRawVersion(resourceId);
            String prettyDatMlRawVersion = DatMlRawVersion.getPrettyDatMlRawVersionFromDatMlRawVerson(datMlRawVersionResId);
            bindingInfo.addAttribute(new BindingInfoAttribute("DatML/RAW-Version", prettyDatMlRawVersion));
        } else if (binding instanceof FieldSetBinding) {
            bindingInfo.setType("Satz");
            SDFElement sdfElement = bindedElementProvider.getBindedElement(binding);
            if (sdfElement != null) {
                if (sdfElement instanceof MetaSDFAusgabegruppe) {
                    int minOccurs;
                    MetaSDFAusgabegruppe fieldSet = (MetaSDFAusgabegruppe)sdfElement;
                    if (fieldSet.getBedingung() != null && fieldSet.getBedingung().length() > 0) {
                        bindingInfo.addAttribute(new BindingInfoAttribute("Bedingung", fieldSet.getBedingung()));
                    }
                    StringBuffer selectors = new StringBuffer();
                    Iterator references = fieldSet.getSDFFeldReferenzen();
                    while (references != null && references.hasNext()) {
                        MetaCustomSDFFeldReferenz reference = (MetaCustomSDFFeldReferenz)references.next();
                        if (!reference.isIstSelektor()) continue;
                        if (selectors.length() > 0) {
                            selectors.append(", ");
                        }
                        selectors.append(reference.getReferenceName());
                        selectors.append(" = ");
                        selectors.append(reference.getVorgabeWert());
                    }
                    if (selectors.length() > 0) {
                        bindingInfo.addAttribute(new BindingInfoAttribute("Selektorbelegung", selectors.toString()));
                    }
                    if ((minOccurs = SDFUtil.getMinOccurs((String)fieldSet.getMinimaleAnzahl())) != -1) {
                        bindingInfo.addAttribute(new BindingInfoAttribute("Minimale Anzahl", "" + minOccurs));
                    }
                    bindingInfo.addAttribute(new BindingInfoAttribute("Maximale Anzahl", SDFUtil.getMaxOccursAsText((String)fieldSet.getMaximaleAnzahl())));
                } else if (sdfElement instanceof MetaSDFMetaAusgabegruppe) {
                    MetaMapping metaMapping = (MetaMapping)binding.getParent();
                    if (binding == metaMapping.getDocumentBinding()) {
                        bindingInfo.setDescription("Die Metadaten des Dokuments.");
                    } else if (binding == metaMapping.getMessageBinding()) {
                        bindingInfo.setDescription("Die Metadaten einer Nachricht.");
                    }
                }
            }
        } else if (binding instanceof FieldGroupBinding) {
            bindingInfo.setType("Merkmalsgruppe");
            SDFElement sdfElement = bindedElementProvider.getBindedElement(binding);
            if (sdfElement != null) {
                MinAndMax minAndMax;
                MetaSDFMerkmalsgruppe merkmalsgruppe;
                MetaSDFFeldReferenz reference;
                if (sdfElement instanceof MetaSDFFeldReferenz) {
                    int minOccurs;
                    reference = (MetaSDFFeldReferenz)sdfElement;
                    merkmalsgruppe = (MetaSDFMerkmalsgruppe)reference.getKlasse();
                    if (merkmalsgruppe.getBeschreibung() != null && merkmalsgruppe.getBeschreibung().length() > 0) {
                        bindingInfo.setDescription(merkmalsgruppe.getBeschreibung());
                    }
                    if ((minOccurs = SDFUtil.getMinOccurs((String)reference.getMinimaleAnzahl())) != -1) {
                        bindingInfo.addAttribute(new BindingInfoAttribute("Minimale Anzahl", "" + minOccurs));
                    }
                    bindingInfo.addAttribute(new BindingInfoAttribute("Maximale Anzahl", SDFUtil.getMaxOccursAsText((String)reference.getMaximaleAnzahl())));
                } else if (sdfElement instanceof MetaSDFMetaFeldReferenz) {
                    reference = (MetaSDFMetaFeldReferenz)sdfElement;
                    merkmalsgruppe = (MetaSDFMetaMerkmalsgruppe)reference.getKlasse();
                    if (merkmalsgruppe.getBeschreibung() != null && merkmalsgruppe.getBeschreibung().length() > 0) {
                        bindingInfo.setDescription(merkmalsgruppe.getBeschreibung());
                    }
                    bindingInfo.addAttribute(new BindingInfoAttribute("Angabe erforderlich", reference.getAttributRequired() == 2 ? "Ja" : "Nein"));
                }
                Integer quantity = ((FieldGroupBinding)binding).getSize();
                String first = "-";
                String last = "-";
                if (quantity != null && quantity > 0 && (minAndMax = BindingHelper.getFirstAndLastCalculatedCsvPosition((FieldGroupBinding)binding)) != null) {
                    first = String.valueOf(minAndMax.getMin());
                    last = String.valueOf(minAndMax.getMax());
                }
                bindingInfo.addAttribute(new BindingInfoAttribute("Erste CSV-Position", first));
                bindingInfo.addAttribute(new BindingInfoAttribute("Letzte CSV-Position", last));
            }
        } else if (binding instanceof FieldBinding) {
            if (binding instanceof SelectorBinding) {
                bindingInfo.setType("Selektor");
            } else {
                bindingInfo.setType("Merkmal");
            }
            SDFElement sdfElement = bindedElementProvider.getBindedElement(binding);
            if (sdfElement != null) {
                Object merkmal = sdfElement instanceof MetaSDFFeldReferenz ? (MetaSDFMerkmal)((MetaSDFFeldReferenz)sdfElement).getKlasse() : (sdfElement instanceof MetaSDFMetaFeldReferenz ? (MetaSDFMerkmal)((MetaSDFMetaFeldReferenz)sdfElement).getKlasse() : null);
                if (merkmal != null) {
                    String valueSpace;
                    if (merkmal.getBeschreibung() != null && merkmal.getBeschreibung().length() > 0) {
                        bindingInfo.setDescription(merkmal.getBeschreibung());
                    }
                    bindingInfo.addAttribute(new BindingInfoAttribute("Typ", SDFUtil.getTypeAsText((short)merkmal.getTyp())));
                    String format = SDFUtil.getFormatAsText((MetaSDFMerkmal)merkmal);
                    if (format != null) {
                        bindingInfo.addAttribute(new BindingInfoAttribute("Format", format));
                    }
                    if ((valueSpace = SDFUtil.getValueSpaceAsText((MetaSDFMerkmal)merkmal)) != null) {
                        if (merkmal.getWertTyp() == 2) {
                            bindingInfo.addAttribute(new BindingInfoAttribute("Muster", valueSpace));
                        } else if (merkmal.getWertTyp() == 3 || merkmal.getWertTyp() == 4) {
                            bindingInfo.addAttribute(new BindingInfoAttribute("Kategorie", valueSpace));
                        } else {
                            bindingInfo.addAttribute(new BindingInfoAttribute("Wertebereich", valueSpace));
                        }
                    }
                }
                if (sdfElement instanceof MetaSDFMetaFeldReferenz) {
                    bindingInfo.addAttribute(new BindingInfoAttribute("Angabe erforderlich", ((MetaSDFMetaFeldReferenz)sdfElement).getAttributRequired() == 2 ? "Ja" : "Nein"));
                }
                if (binding instanceof SelectorBinding) {
                    bindingInfo.setComment("Das Merkmal " + merkmal.getName() + " unterscheidet verschiedene Typen von Datens\u00e4tzen; in der elekronischen Erhebungsbeschreibung ist das Merkmal mit dem passenden Wert vorbelegt und mu\u00df lediglich in das Lieferdokument \u00fcbernommen werden.");
                }
            }
        } else {
            bindingInfo.setType("Unbekannt");
            bindingInfo.setDescription("Keine Information zum ausgew\u00e4hlten Element vorhanden");
        }
        return bindingInfo;
    }

    public static class MinAndMax {
        private int min = Integer.MAX_VALUE;
        private int max = Integer.MIN_VALUE;

        protected MinAndMax() {
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        protected void update(int value) {
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
        }

        protected void update(MinAndMax subMinAndMax) {
            if (subMinAndMax.min < this.min) {
                this.min = subMinAndMax.min;
            }
            if (subMinAndMax.max > this.max) {
                this.max = subMinAndMax.max;
            }
        }
    }
}

