/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.editor.util.CsvTableCreator;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.HelpFeatureBinding;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.destatis.core.map.model.SelectorBinding;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MappingCsvTemplateCreator
extends CsvTableCreator {
    private Mapping mapping;
    private MetaErhebungsbeschreibung metaErhebungsbeschreibung;
    private File file;
    private boolean separateFiles;
    private List writtenFiles;

    public MappingCsvTemplateCreator(Mapping mapping, MetaErhebungsbeschreibung metaErhebungsbeschreibung, File file, boolean separateFiles, String encoding, char csvSeparator, char csvQuote) {
        super(encoding, csvSeparator, csvQuote);
        this.mapping = mapping;
        this.metaErhebungsbeschreibung = metaErhebungsbeschreibung;
        this.file = file;
        this.separateFiles = separateFiles;
        this.writtenFiles = new ArrayList();
    }

    @Override
    public void run() {
        try {
            this.createTemplate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List getWrittenFiles() {
        return this.writtenFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTemplate() throws IOException {
        FileOutputStream fOut = null;
        try {
            if (this.separateFiles) {
                if (!this.file.isDirectory() && !this.file.mkdirs()) {
                    throw new IOException("Das Zielverzeichnis '" + this.file.getAbsolutePath() + "' existiert nicht und konnte nicht angelegt werden.");
                }
            } else {
                File directory = this.file.getParentFile();
                if (directory != null && !directory.isDirectory() && !directory.mkdirs()) {
                    throw new IOException("Das Verzeichnis der Zieldatei '" + this.file.getAbsolutePath() + "' existiert nicht und konnte nicht angelegt werden.");
                }
            }
            ArrayList<Binding> helpFeatures = new ArrayList<Binding>();
            int maxHelpFeaturesPos = -1;
            ArrayList<Binding> selectors = new ArrayList<Binding>();
            int maxSelectorsPos = -1;
            Iterator it = this.mapping.getBindings();
            while (it.hasNext()) {
                Integer position;
                Binding binding = (Binding)it.next();
                if (binding instanceof HelpFeatureBinding) {
                    position = ((HelpFeatureBinding)binding).getPosition();
                    if (position == null || position <= 0) continue;
                    helpFeatures.add(binding);
                    if (position <= maxHelpFeaturesPos) continue;
                    maxHelpFeaturesPos = position;
                    continue;
                }
                if (!(binding instanceof SelectorBinding) || (position = ((SelectorBinding)binding).getPosition()) == null || position <= 0) continue;
                selectors.add(binding);
                if (position <= maxSelectorsPos) continue;
                maxSelectorsPos = position;
            }
            HelpFeatureConfigValue helpFeatureConfig = this.mapping.getHelpFeatureConfig();
            BufferedWriter writer = null;
            if (helpFeatureConfig.isSeparateRow() || !this.separateFiles) {
                File mainOutputFile = this.separateFiles ? new File(this.file, "Hilfsmerkmale.csv") : this.file;
                fOut = new FileOutputStream(mainOutputFile);
                this.writtenFiles.add(mainOutputFile);
                writer = this.encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)fOut, this.encoding)) : new BufferedWriter(new OutputStreamWriter(fOut));
            }
            if (helpFeatureConfig.isSeparateRow()) {
                if (helpFeatures.size() > 0) {
                    Object[] csvRecord = new Object[maxHelpFeaturesPos];
                    this.fillForFieldBindings(csvRecord, helpFeatures);
                    this.writeCsvRecord(writer, csvRecord);
                }
                if (!this.separateFiles) {
                    writer.newLine();
                }
            }
            MetaSDFAusgabesatz ausgabesatz = this.metaErhebungsbeschreibung.getAusgabesatz();
            it = this.mapping.getBindings();
            int satzCounter = 0;
            while (it.hasNext()) {
                Object[] csvRecord;
                Binding binding = (Binding)it.next();
                if (!(binding instanceof FieldSetBinding)) continue;
                FieldSetBinding fieldSetBinding = (FieldSetBinding)binding;
                MetaSDFAusgabegruppe ausgabegruppe = null;
                Iterator ausgabegruppenIt = ausgabesatz.getAusgabegruppen();
                while (ausgabegruppenIt.hasNext()) {
                    MetaSDFAusgabegruppe tmp = (MetaSDFAusgabegruppe)ausgabegruppenIt.next();
                    if (1 != tmp.getAttributDaten() || !tmp.getName().equals(fieldSetBinding.getId())) continue;
                    ausgabegruppe = tmp;
                    break;
                }
                if ((csvRecord = this.createSatzRecord(fieldSetBinding, ausgabegruppe, helpFeatures, maxHelpFeaturesPos, selectors, maxSelectorsPos)) == null) continue;
                ++satzCounter;
                if (this.separateFiles) {
                    if (writer != null) {
                        writer.close();
                        fOut = null;
                    }
                    String satzName = "Satz_" + satzCounter;
                    String id = fieldSetBinding.getId();
                    if (id != null) {
                        id = id.trim();
                    }
                    if (id != null && id.length() > 0) {
                        satzName = satzName + "_" + id;
                    }
                    File satzFile = this.getFile(satzName);
                    fOut = new FileOutputStream(satzFile);
                    this.writtenFiles.add(satzFile);
                    writer = this.encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)fOut, this.encoding)) : new BufferedWriter(new OutputStreamWriter(fOut));
                } else if (satzCounter > 1) {
                    writer.newLine();
                }
                this.writeCsvRecord(writer, csvRecord);
            }
            if (writer != null) {
                writer.close();
                fOut = null;
            }
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Object[] createSatzRecord(FieldSetBinding fieldSetBinding, MetaSDFAusgabegruppe ausgabegruppe, List helpFeatures, int maxHelpFeaturesPos, List selectors, int maxSelectorsPos) {
        HelpFeatureConfigValue helpFeatureConfig;
        int maxPos = -1;
        Integer lastSatzPos = BindingHelper.getLastCalculatedCsvPosition(fieldSetBinding);
        if (lastSatzPos != null) {
            maxPos = lastSatzPos;
        }
        if ((helpFeatureConfig = this.mapping.getHelpFeatureConfig()).isEachRecord() && helpFeatures.size() > 0 && maxHelpFeaturesPos > maxPos) {
            maxPos = maxHelpFeaturesPos;
        }
        if (selectors.size() > 0 && maxSelectorsPos > maxPos) {
            maxPos = maxHelpFeaturesPos;
        }
        Object[] record = null;
        if (maxPos > 0) {
            record = new Object[maxPos];
            if (helpFeatureConfig.isEachRecord() && helpFeatures.size() > 0) {
                this.fillForFieldBindings(record, helpFeatures);
            }
            if (selectors.size() > 0) {
                this.fillSelectors(record, selectors, ausgabegruppe);
            }
            if (lastSatzPos != null) {
                this.fillForFieldSet(record, fieldSetBinding);
            }
        }
        return record;
    }

    protected void fillSelectors(Object[] record, List selectors, MetaSDFAusgabegruppe ausgabegruppe) {
        for (SelectorBinding selectorBinding : selectors) {
            String id = selectorBinding.getId();
            int pos = selectorBinding.getPosition() - 1;
            String value = null;
            if (ausgabegruppe != null) {
                Iterator references = ausgabegruppe.getSDFFeldReferenzen();
                while (references.hasNext()) {
                    MetaSDFFeldReferenz reference = (MetaSDFFeldReferenz)references.next();
                    if (!reference.isIstSelektor() || !reference.getKlasse().getName().equals(id)) continue;
                    value = reference.getVorgabeWert();
                    break;
                }
            }
            if (value == null) {
                value = selectorBinding.getId();
            }
            record[pos] = value;
        }
    }

    protected File getFile(String satzName) {
        satzName = satzName.replace('\\', '_');
        satzName = satzName.replace('/', '_');
        satzName = satzName.replace(':', '_');
        satzName = satzName.replace('?', '_');
        satzName = satzName.replace('<', '_');
        satzName = satzName.replace('>', '_');
        satzName = satzName.replace('|', '_');
        String satzFileName = satzName + ".csv";
        File satzFile = new File(this.file, satzFileName);
        return satzFile;
    }
}

