/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.treetable;

import de.destatis.core.map.editor.treetable.TreeTableModel;
import de.destatis.core.map.editor.treetable.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTable
extends JTable
implements MouseListener {
    protected static Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    protected TreeTableCellRenderer tableRenderer = new TreeTableCellRenderer(this);
    private Color treeBackground = null;
    private static final long serialVersionUID = -5029984201048159947L;

    public TreeTable() {
        this(new DefaultTreeTableModel());
    }

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
        this.tableRenderer.getTree().setSelectionModel(new DefaultTreeSelectionModel(){
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.setDefaultRenderer(TreeTableModel.class, this.tableRenderer);
        this.addMouseListener(this);
        this.initAltGrKeyStrokes();
    }

    public void setModel(TreeTableModel treeTableModel) {
        this.tableRenderer.setModel(treeTableModel);
        this.setModel(new TreeTableModelAdapter(treeTableModel, this.tableRenderer.getTree()));
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.tableRenderer.getTree().setCellRenderer(renderer);
    }

    public Color getTreeBackground() {
        Color result = this.treeBackground;
        if (result == null) {
            result = this.getBackground();
        }
        return result;
    }

    public void setTreeBackground(Color treeBackground) {
        this.treeBackground = treeBackground;
    }

    public JTree getTree() {
        if (this.tableRenderer == null) {
            this.tableRenderer = new TreeTableCellRenderer(this);
        }
        return this.tableRenderer.getTree();
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.tableRenderer.getTree().expandRow(i);
        }
    }

    public void expandRow(int row) {
        this.tableRenderer.getTree().expandRow(row);
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.tableRenderer.getTree().collapseRow(i);
        }
    }

    private void expandRoot() {
        TreeModel model = this.tableRenderer.getTree().getModel();
        if (model != null && model.getRoot() != null) {
            this.tableRenderer.getTree().expandPath(new TreePath(model.getRoot()));
        }
    }

    @Override
    public int getEditingRow() {
        int editingColumn = this.getEditingColumn();
        return editingColumn != -1 && this.getColumnClass(editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private void translateMouseEventToTree(MouseEvent e) {
        int row;
        int column = this.columnAtPoint(e.getPoint());
        if (this.getColumnClass(column) == TreeTableModel.class && (row = this.rowAtPoint(e.getPoint())) >= 0) {
            int dx = 0;
            int dy = 0;
            Rectangle tableCellRect = this.getCellRect(row, column, false);
            Rectangle treeCellRect = this.getTree().getRowBounds(row);
            if (tableCellRect != null) {
                dx = -tableCellRect.x;
                if (treeCellRect != null) {
                    dy = treeCellRect.y - tableCellRect.y;
                }
            }
            this.getTree().dispatchEvent(new MouseEvent(this.getTree(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() + dx, e.getY() + dy, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.translateMouseEventToTree(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.translateMouseEventToTree(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.translateMouseEventToTree(e);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.getInputMap(condition).get(ks) == null) {
            if (this.isInvalidKeyEvent(e)) {
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected boolean isInvalidKeyEvent(KeyEvent e) {
        if (e.isAltDown() && e.isControlDown() && e.getKeyCode() == 0) {
            return false;
        }
        if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
            return true;
        }
        switch (e.getKeyCode()) {
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    protected void initAltGrKeyStrokes() {
        Vector<KeyStroke> altGrKeyStrokes = new Vector<KeyStroke>();
        KeyStroke keyStrokeToAdd = KeyStroke.getKeyStroke("control alt Q");
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke("control alt E");
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke(153, 10);
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke("control alt 7");
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke("control alt 8");
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke("control alt 9");
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke("control alt 0");
        altGrKeyStrokes.add(keyStrokeToAdd);
        keyStrokeToAdd = KeyStroke.getKeyStroke(521, 10);
        altGrKeyStrokes.add(keyStrokeToAdd);
        InputMap im = this.getInputMap(1);
        Iterator it = altGrKeyStrokes.iterator();
        while (it.hasNext()) {
            im.put((KeyStroke)it.next(), "");
        }
    }

    private static class DefaultTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private static final long serialVersionUID = -9116870341824229114L;

        public DefaultTreeTableModel() {
            super(null);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "Tree";
        }

        @Override
        public Object getValueAt(Object node, int column) {
            return node;
        }

        @Override
        public Class getColumnClass(int column) {
            return TreeTableModel.class;
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, Object node, int column) {
        }
    }

    private class TreeTableCellRenderer
    extends JComponent
    implements TableCellRenderer,
    LayoutManager {
        protected int visibleRow;
        protected boolean hasFocus;
        private static final long serialVersionUID = 4420510748504659591L;
        private TreeTable treeTable;
        private JTree tree;
        private int rowHeight;

        public TreeTableCellRenderer(TreeTable treeTable2) {
            this.treeTable = treeTable2;
            this.tree = new JTree();
            this.tree.setShowsRootHandles(true);
            this.rowHeight = treeTable2.getRowHeight();
            this.setOpaque(false);
            this.setLayout(this);
            this.add(this.tree);
        }

        public TreeTableCellRenderer(TreeTable treeTable2, TreeModel model) {
            this(treeTable2);
            this.setModel(model);
        }

        public void setModel(TreeModel model) {
            this.tree.setModel(model);
        }

        public JTree getTree() {
            return this.tree;
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, this.treeTable.getModel().getRowCount() * this.tree.getRowHeight() + this.rowHeight);
        }

        @Override
        public void paint(Graphics g) {
            int deltaY = this.visibleRow * this.tree.getRowHeight() + this.tree.getRowHeight() - this.treeTable.getRowHeight() / 2;
            g.translate(0, -deltaY);
            super.paint(g);
            g.translate(0, deltaY);
            if (this.hasFocus) {
                focusBorder.paintBorder(this.tree, g, 0, 0, this.getWidth(), this.rowHeight - this.treeTable.getIntercellSpacing().height);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            this.visibleRow = row;
            this.hasFocus = isFocused;
            this.rowHeight = table.getRowHeight(row);
            this.tree.setRowHeight(this.rowHeight * 2);
            if (isSelected) {
                this.tree.setBackground(table.getSelectionBackground());
            } else {
                this.tree.setBackground(((TreeTable)table).getTreeBackground());
            }
            return this;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            this.tree.setBounds(0, this.rowHeight, parent.getWidth(), parent.getHeight());
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

