/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.model.BindingHelper;
import java.util.Iterator;

public abstract class MappingMerge {
    protected void mergeBindingGroupElements(BindingGroup target, BindingGroup source) {
        Iterator it = target.getBindings();
        while (it.hasNext()) {
            Binding targetBinding = (Binding)it.next();
            Binding sourceBinding = BindingHelper.getBindingById(source, targetBinding.getId());
            if (sourceBinding == null || !sourceBinding.getClass().equals(targetBinding.getClass())) continue;
            if (targetBinding instanceof FieldBinding) {
                this.mergeFieldBinding((FieldBinding)targetBinding, (FieldBinding)sourceBinding);
                continue;
            }
            if (targetBinding instanceof FieldGroupBinding) {
                this.mergeFieldGroupBinding((FieldGroupBinding)targetBinding, (FieldGroupBinding)sourceBinding);
                continue;
            }
            if (targetBinding instanceof FieldSetBinding) {
                this.mergeFieldSetBinding((FieldSetBinding)targetBinding, (FieldSetBinding)sourceBinding);
                continue;
            }
            throw new IllegalStateException("Ung\u00fcltiger Bindingtyp: " + targetBinding.getClass().getName());
        }
    }

    protected void mergeFieldBinding(FieldBinding target, FieldBinding source) {
        target.setCustomName(source.getCustomName());
        target.setDefaultValue(source.getDefaultValue());
        target.setPosition(source.getPosition());
    }

    protected void mergeFieldSetBinding(FieldSetBinding target, FieldSetBinding source) {
        this.mergeBindingGroupElements(target, source);
    }

    protected void mergeFieldGroupBinding(FieldGroupBinding target, FieldGroupBinding source) {
        target.setCustomName(source.getCustomName());
        target.setSize(source.getSize());
        this.mergeBindingGroupElements(target, source);
    }
}

