/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator;

import de.destatis.core.generator.Descriptor;
import de.destatis.core.generator.StructureDescriptor;

public abstract class AbstractDescriptor
implements Descriptor {
    public static final String PATH_SEPARATOR = ".";
    public static final String INDEX_LPAREN = "[";
    public static final String INDEX_RPAREN = "]";
    protected String name;
    protected String customName;
    protected StructureDescriptor parent;
    private int pathLength = -1;

    protected AbstractDescriptor() {
    }

    protected AbstractDescriptor(StructureDescriptor parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public StructureDescriptor getParent() {
        return this.parent;
    }

    @Override
    public Descriptor[] getPath() {
        int pathLength = this.getPathLength();
        Descriptor[] result = new Descriptor[pathLength];
        int index = pathLength - 1;
        result[index] = this;
        StructureDescriptor parent = this.getParent();
        if (parent != null) {
            do {
                result[--index] = parent;
            } while ((parent = parent.getParent()) != null);
        }
        return result;
    }

    @Override
    public int getPathLength() {
        if (this.pathLength <= 0) {
            int length = 1;
            for (StructureDescriptor parent = this.getParent(); parent != null; parent = parent.getParent()) {
                ++length;
            }
            this.pathLength = length;
        }
        return this.pathLength;
    }

    @Override
    public String getPathString() {
        return AbstractDescriptor.getSubPathString(this, 0);
    }

    public static final String getSubPathString(Descriptor descriptor, int startIndex) {
        return AbstractDescriptor.getSubPathString(descriptor, startIndex, false);
    }

    public static final String getCustomNamesPathString(Descriptor descriptor) {
        return AbstractDescriptor.getSubPathString(descriptor, 0, true);
    }

    private static final String getSubPathString(Descriptor descriptor, int startIndex, boolean useCustomNames) {
        StringBuffer pathString = new StringBuffer();
        Descriptor[] path = descriptor.getPath();
        int len = path.length;
        int lenMinus1 = len - 1;
        for (int i = startIndex; i < len; ++i) {
            Integer index;
            String elementName;
            Descriptor pathElemement = path[i];
            if (useCustomNames) {
                elementName = pathElemement.getCustomName();
                if (elementName == null) {
                    elementName = pathElemement.getName();
                }
            } else {
                elementName = pathElemement.getName();
            }
            pathString.append(elementName);
            if (pathElemement instanceof StructureDescriptor && (index = ((StructureDescriptor)pathElemement).getIndex()) != null) {
                pathString.append(INDEX_LPAREN);
                pathString.append(index);
                pathString.append(INDEX_RPAREN);
            }
            if (i >= lenMinus1) continue;
            pathString.append(PATH_SEPARATOR);
        }
        return pathString.toString();
    }
}

