/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.registry.util.EntityVisitorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsCollator {
    final HasMetricsFilter methodFilter = new HasMetricsFilter(){

        public boolean accept(HasMetrics hm) {
            return hm.getMetrics().getPcCoveredElements() != 1.0f && hm.getMetrics().getNumElements() > 0;
        }
    };
    final EntityVisitorUtils entityUtils = new EntityVisitorUtils();

    public List<MethodInfo> getLeastTestedMethods(List<? extends ClassInfo> classes, boolean showLambdaFunctions, boolean showInnerFunctions) {
        ArrayList<MethodInfo> methodsLeastTested = new ArrayList<MethodInfo>();
        int numMethods = 20;
        for (ClassInfo classInfo : classes) {
            for (MethodInfo methodInfo : classInfo.getAllMethods()) {
                if (!this.methodFilter.accept(methodInfo) || !showLambdaFunctions && methodInfo.isLambda() || !showInnerFunctions && this.entityUtils.isInnerMethod(methodInfo)) continue;
                methodsLeastTested.add(methodInfo);
            }
        }
        ArrayList<HasMetricsSupport.HasMetricsComparator> comparators = new ArrayList<HasMetricsSupport.HasMetricsComparator>();
        comparators.add(HasMetricsSupport.CMP_PC_ASC);
        comparators.add(HasMetricsSupport.CMP_ELEMENTS_UNCOVERED_DESC);
        comparators.add(HasMetricsSupport.CMP_COMPLEXITY_DESC);
        HasMetricsSupport.HasMetricsComparatorChain hasMetricsComparatorChain = new HasMetricsSupport.HasMetricsComparatorChain(comparators);
        Collections.sort(methodsLeastTested, hasMetricsComparatorChain);
        int toIndex = methodsLeastTested.size() < numMethods ? methodsLeastTested.size() : numMethods;
        return methodsLeastTested.subList(0, toIndex);
    }

    public List getTopRisks(Map classMap, int risksCount) {
        int count = 0;
        ArrayList topRisks = new ArrayList(risksCount);
        for (Integer key : classMap.keySet()) {
            List list = (List)classMap.get(key);
            int size = list.size();
            if (count + size >= risksCount) {
                int diff = risksCount - count;
                topRisks.addAll(list.subList(0, diff));
                break;
            }
            topRisks.addAll(list);
            count += size;
        }
        return topRisks;
    }

    public Map rankProjectRisks(List pceOrder, List amcOrder) {
        TreeMap classMap = new TreeMap();
        int i = 0;
        for (BaseClassInfo info : pceOrder) {
            List<BaseClassInfo> value;
            int rank = amcOrder.indexOf(info) + ++i;
            Integer key = new Integer(rank);
            if (classMap.containsKey(key)) {
                value = (List)classMap.get(key);
            } else {
                value = new ArrayList();
                classMap.put(key, value);
            }
            value.add(info);
        }
        return classMap;
    }

    public List getTopOfList(List infos, int topNCount, HasMetricsSupport.HasMetricsComparator cmp) {
        Collections.sort(infos, cmp);
        Collections.reverse(infos);
        int last = infos.size() >= topNCount ? topNCount : infos.size();
        return infos.subList(0, last);
    }
}

