/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import de.memtext.util.DateUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.InfoMessage;
import de.superx.dbadmin.AdminOrgaMouseListener;
import de.superx.dbadmin.AdminOrgaPrintRenderer;
import de.superx.dbadmin.AdminOrgaSelList;
import de.superx.dbadmin.DBAccess;
import de.superx.dbadmin.MBDragTree;
import de.superx.dbadmin.OrgaBearbDialog;
import de.superx.dbadmin.OrgaEintrag2;
import de.superx.dbadmin.SuperXDBAdmin;
import de.superx.dbadmin.SxDefaults;
import de.superx.dbadmin.SxUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class AdminOrga
extends JPanel
implements Printable,
ActionListener,
KeyListener {
    private boolean result;
    private boolean isSaveNecessary = false;
    private OrgaEintrag2 gewaehlt;
    private OrgaEintrag2 einEintrag;
    private Vector orga;
    private Vector merkung\u00fcltig;
    private int entryCount;
    private JLabel standLbl;
    private GregorianCalendar cal = new GregorianCalendar();
    private String standDatum;
    private JTextField suchtext;
    private Container cp;
    private MBDragTree tree;
    private DefaultTreeModel treeModel;
    private JScrollPane treeScroll;
    private DefaultMutableTreeNode root;
    private String logToKonsole;
    private String sx_db;

    public AdminOrga() {
        this.setLayout(new BorderLayout());
        this.standDatum = String.valueOf(this.cal.get(5)) + "." + (this.cal.get(2) + 1) + "." + this.cal.get(1);
        JPanel top = new JPanel();
        this.standLbl = new JLabel("Stand: " + this.standDatum);
        this.standLbl.setFont(new Font("Arial", 0, 10));
        JButton bStand = new JButton("anderer Stand");
        bStand.setFont(new Font("Arial", 0, 10));
        bStand.setDefaultCapable(false);
        bStand.addActionListener(this);
        top.add(this.standLbl);
        top.add(bStand);
        JButton bprintanzeige = new JButton("(Druckanzeige)");
        bprintanzeige.addActionListener(this);
        bprintanzeige.setFont(new Font("Arial", 0, 10));
        this.add((Component)top, "North");
        this.tree = new MBDragTree();
        this.tree.setRootVisible(false);
        this.tree.setEditable(true);
        this.treeScroll = new JScrollPane(this.tree);
        this.add((Component)this.treeScroll, "Center");
        JPanel down = new JPanel();
        down.setLayout(new GridLayout(4, 1));
        JPanel psuchen = new JPanel();
        this.suchtext = new JTextField(10);
        this.suchtext.setFont(new Font("Arial", 0, 10));
        psuchen.add(this.suchtext);
        JButton suchen = new JButton("Suchen");
        suchen.setFont(new Font("Arial", 0, 10));
        suchen.addActionListener(this);
        psuchen.add(suchen);
        down.add(psuchen);
        JPanel phinl\u00f6 = new JPanel();
        JLabel lKnoten = new JLabel("Knoten:");
        phinl\u00f6.add(lKnoten);
        JButton Nedit = new JButton("bearbeiten");
        Nedit.addActionListener(this);
        phinl\u00f6.add(Nedit);
        JButton Nadd = new JButton("hinzuf\u00fcgen");
        Nadd.addActionListener(this);
        phinl\u00f6.add(Nadd);
        JButton Ndel = new JButton("l\u00f6schen");
        Ndel.addActionListener(this);
        phinl\u00f6.add(Ndel);
        down.add(phinl\u00f6);
        JPanel pIO = new JPanel();
        JLabel lorg = new JLabel("Organigramm:");
        pIO.add(lorg);
        JButton bspeichern = new JButton("speichern");
        bspeichern.addActionListener(this);
        pIO.add(bspeichern);
        JButton bneulesen = new JButton("neu einlesen");
        bneulesen.addActionListener(this);
        pIO.add(bneulesen);
        JButton bwieder = new JButton("Backup wiederherstellen");
        bwieder.addActionListener(this);
        pIO.add(bwieder);
        down.add(pIO);
        this.add("South", down);
        this.sx_db = (String)SxDefaults.getPropertyValue("SxDB");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Suchen")) {
            this.suchen();
        }
        if (event.getActionCommand().equals("(Druckanzeige)")) {
            this.druckanzeige();
        }
        if (event.getActionCommand().equals("anderer Stand")) {
            this.stand\u00c4ndern();
        }
        if (event.getActionCommand().equals("bearbeiten")) {
            this.bearbeiten();
        }
        if (event.getActionCommand().equals("speichern")) {
            this.speichern();
        }
        if (event.getActionCommand().equals("neu einlesen")) {
            this.readTreeFromDb();
        }
        if (event.getActionCommand().equals("Backup wiederherstellen")) {
            this.backupRestore();
        }
        if (event.getActionCommand().equals("l\u00f6schen")) {
            this.l\u00f6schenNode();
        }
        if (event.getActionCommand().equals("hinzuf\u00fcgen")) {
            this.addNode();
        }
    }

    private void addNode() {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.tree.getSelectionPath();
        parentNode = parentPath == null ? this.root : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        int ebene = parentNode.getLevel();
        OrgaEintrag2 parentEintrag = (OrgaEintrag2)parentNode.getUserObject();
        Date gueltig_seit = new Date(1L);
        gueltig_seit = Date.valueOf("2001-10-01");
        Date gueltig_bis = new Date(1L);
        gueltig_bis = Date.valueOf("2999-01-01");
        OrgaEintrag2 neuerEintrag = new OrgaEintrag2("Neue OrgaEinheit", "", new String("1"), new Integer(ebene), parentEintrag.getKeyApnr(), new Integer(1), gueltig_seit, gueltig_bis, new Integer(0));
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(neuerEintrag);
        OrgaBearbDialog dlg = new OrgaBearbDialog((Frame)this.getTopLevelAncestor(), childNode, this.merkung\u00fcltig, (DefaultMutableTreeNode)parentNode.getRoot());
        if (childNode != null && !(neuerEintrag = (OrgaEintrag2)childNode.getUserObject()).getName().equals("Neue OrgaEinheit")) {
            this.treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
            this.setSaveNecessary(true);
        }
    }

    private void stand\u00c4ndern() {
        String neuesStandDatum;
        int result;
        if (this.isSaveNecessary && (result = JOptionPane.showConfirmDialog(null, "Bei Auswahl eines anderen Stands gehen eventuell gemachte \u00c4nderungen verloren!\n                                                  Erst speichern?", "SuperX DB Admin", 0)) == 0) {
            this.speichern();
        }
        if ((neuesStandDatum = JOptionPane.showInputDialog(this, "Neues Datum eingeben:", "SuperX", 3)) != null && DateUtils.isValidDate(neuesStandDatum)) {
            this.standDatum = neuesStandDatum;
            this.standLbl.setText("Stand: " + this.standDatum);
            this.readTreeFromDb();
            this.validate();
            WindowUtils.setWaitCursor(this, false);
        }
    }

    public void backupAnlegen() {
        InfoMessage.show((Component)this, "Achtung!\nBevor Sie das Organigramm bearbeiten sollen Sie auf Datenbankseite eine Sicherung mit\n unload (Informix) bzw. copyto (Postgres) anlegen, damit Sie es bei evtl. Problemen wieder einspielen k\u00f6nnen.", "AdminTool");
        WindowUtils.setWaitCursor(this, true);
        try {
            DBAccess.executeUpdate("delete from organigramm_bak where 1=1");
            DBAccess.executeUpdate("insert into organigramm_bak select * from organigramm");
            SuperXDBAdmin.setStatus(String.valueOf(SuperXDBAdmin.getStatus()) + " - backup angelegt!");
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Fehler beim Schreiben in die Datenbank: " + e2.toString(), "SuperX DB Admin", 2);
            e2.printStackTrace();
        }
    }

    private void backupRestore() {
        boolean OK = true;
        try {
            DBAccess.executeUpdate("delete from organigramm where 1=1");
            DBAccess.executeUpdate("insert into organigramm select * from organigramm_bak");
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Fehler beim Schreiben in die Datenbank: " + e2.toString(), "SuperX DB Admin", 2);
            e2.printStackTrace();
            OK = false;
        }
        if (OK) {
            this.readTreeFromDb();
            JOptionPane.showMessageDialog(null, "Backup wieder hergestellt!", "SuperX DB Admin", 1);
        }
    }

    public void bearbeiten() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        OrgaBearbDialog dlg2 = new OrgaBearbDialog((Frame)this.getTopLevelAncestor(), node, this.merkung\u00fcltig);
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        dtm.nodeChanged(node);
        this.setSaveNecessary(true);
    }

    public String dateToString(Date inp) {
        DateFormat df = DateFormat.getDateInstance(2);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        String help = df.format(inp);
        return help;
    }

    public void druckanzeige() {
        DefaultMutableTreeNode aNode;
        AdminOrgaPrintRenderer aopr = new AdminOrgaPrintRenderer();
        this.tree.setCellRenderer(aopr);
        DefaultMutableTreeNode theRoot = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> en = theRoot.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            aNode = (DefaultMutableTreeNode)en.nextElement();
            TreePath tp = new TreePath(aNode.getPath());
            if (!this.tree.isCollapsed(tp)) continue;
            this.tree.expandPath(tp);
        }
        this.printTree();
        Enumeration<TreeNode> en2 = theRoot.depthFirstEnumeration();
        while (en2.hasMoreElements()) {
            aNode = (DefaultMutableTreeNode)en2.nextElement();
            if (!(aNode.getUserObject() instanceof OrgaEintrag2)) continue;
            OrgaEintrag2 x = (OrgaEintrag2)aNode.getUserObject();
            int level = aNode.getLevel();
            int i2 = 1;
            while (i2 <= level) {
                System.out.print("   ");
                ++i2;
            }
            String keyApnr = x.getKeyApnr() == null ? "" : x.getKeyApnr().toString();
            System.out.println(String.valueOf(x.getName()) + "  (" + keyApnr + ")");
        }
    }

    public static Date getDate(String value) {
        DateFormat df = DateFormat.getDateInstance(2);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        try {
            if (value.endsWith("00")) {
                switch (value.charAt(value.length() - 3)) {
                    case '-': 
                    case '.': 
                    case '/': {
                        value = String.valueOf(value.substring(0, value.length() - 2)) + "2000";
                    }
                }
            }
            java.util.Date date = df.parse(value);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            if (year >= 0 && year < 30) {
                calendar.add(1, 2000);
            }
            if (year >= 30 && year < 100) {
                calendar.add(1, 1900);
            }
            Date sql_date = new Date(calendar.getTime().getTime());
            return sql_date;
        }
        catch (ParseException parseException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public OrgaEintrag2 getGewaehlt() {
        return this.gewaehlt;
    }

    private void insertnodes(String theParent, DefaultMutableTreeNode aktNode) {
        Vector result = new Vector();
        result = this.mySelect(theParent);
        Enumeration el = result.elements();
        while (el.hasMoreElements()) {
            this.einEintrag = (OrgaEintrag2)el.nextElement();
            DefaultMutableTreeNode neuNode = new DefaultMutableTreeNode(this.einEintrag);
            aktNode.add(neuNode);
            String eintrag_key = this.einEintrag.getKeyApnr();
            if (eintrag_key != null & theParent == null) {
                this.insertnodes(this.einEintrag.getKeyApnr(), neuNode);
            }
            if (eintrag_key == null & theParent == null) {
                System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + this.einEintrag.getName());
            }
            if (eintrag_key == null || theParent == null) continue;
            if (!theParent.equals(eintrag_key)) {
                this.insertnodes(this.einEintrag.getKeyApnr(), neuNode);
                continue;
            }
            System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + this.einEintrag.getName() + " key_apnr:" + this.einEintrag.getKeyApnr());
        }
    }

    public int getChildCount(DefaultMutableTreeNode node) {
        int z\u00e4hler = 0;
        Enumeration<TreeNode> en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            ++z\u00e4hler;
        }
        return z\u00e4hler - 1;
    }

    public void log(String was) {
        System.out.println(was);
    }

    private void l\u00f6schenNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            this.setSaveNecessary(true);
            return;
        }
    }

    private Vector mySelect(String pruefparent) {
        Vector<OrgaEintrag2> result = new Vector<OrgaEintrag2>();
        Enumeration el = this.orga.elements();
        while (el.hasMoreElements()) {
            this.einEintrag = (OrgaEintrag2)el.nextElement();
            String eintrag_parent = this.einEintrag.getParent();
            if (eintrag_parent == null && pruefparent == null) {
                result.addElement(this.einEintrag);
            }
            if (eintrag_parent == null || pruefparent == null || !eintrag_parent.equals(pruefparent)) continue;
            result.addElement(this.einEintrag);
        }
        return result;
    }

    @Override
    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(Color.black);
        int fontHeight = g22.getFontMetrics().getHeight();
        int fontDesent = g22.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight - (double)fontDesent;
        double pageWidth = pageFormat.getImageableWidth();
        double treeWidth = 1.0;
        double scale = 1.0;
        if (treeWidth >= pageWidth) {
            scale = pageWidth / treeWidth;
        }
        double treeWidthOnPage = treeWidth * scale;
        double oneRowHeight = (double)this.tree.getRowHeight() * scale;
        int numRowsOnAPage = (int)((pageHeight - 90.0) / oneRowHeight);
        double pageHeightForTree = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.tree.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        Font font = g22.getFont();
        Font pr_font = new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * scale));
        Font b_font = new Font(font.getFontName(), 1, (int)((double)font.getSize() * scale));
        g22.setFont(pr_font);
        g22.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int footWidth = g22.getFontMetrics().stringWidth("Seite #");
        g22.setFont(b_font);
        g22.drawString("SuperX", 0, (int)(pageHeight + (double)fontHeight));
        g22.setFont(pr_font);
        g22.drawString("Seite " + (pageIndex + 1), (int)(pageWidth / 2.0 - (double)(footWidth / 2)), (int)(pageHeight + (double)fontHeight));
        g22.setFont(pr_font);
        g22.translate(0.0, 90.0);
        g22.translate(0.0, (double)(-pageIndex) * pageHeightForTree);
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = this.tree.getRowCount() - lastRowPrinted;
            g22.setClip(0, (int)(pageHeightForTree * (double)pageIndex), (int)Math.ceil(treeWidthOnPage), (int)Math.ceil(pageHeightForTree));
        } else {
            g22.setClip(0, (int)(pageHeightForTree * (double)pageIndex), (int)Math.ceil(treeWidthOnPage), (int)Math.ceil(pageHeightForTree));
        }
        g22.scale(scale, scale);
        try {
            this.tree.print(g22);
        }
        catch (IllegalArgumentException t_ex) {
            System.err.println(t_ex);
        }
        return 0;
    }

    public void printTree() {
        PageFormat defaultFormat;
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pageFormat = pj.pageDialog(defaultFormat = pj.defaultPage());
        if (pageFormat.equals(defaultFormat)) {
            return;
        }
        Paper a4 = new Paper();
        a4.setSize(595.275590551181, 841.8897637795275);
        a4.setImageableArea(36.0, 36.0, 523.275590551181, 769.8897637795275);
        pageFormat.setPaper(a4);
        defaultFormat = pageFormat;
        pj.setPrintable(this, pageFormat);
        if (!pj.printDialog()) {
            return;
        }
        try {
            pj.print();
        }
        catch (Exception PrintException2) {
            System.err.println(PrintException2);
            PrintException2.printStackTrace();
        }
    }

    public void pr\u00fcfeDifferenzen(DefaultMutableTreeNode root) {
        OrgaEintrag2 x;
        Vector problemf\u00e4lle = (Vector)this.orga.clone();
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            x = (OrgaEintrag2)aNode.getUserObject();
            problemf\u00e4lle.remove(x);
        }
        if (problemf\u00e4lle.size() > 0) {
            JOptionPane.showMessageDialog(null, "Achtung!\nEs gibt " + problemf\u00e4lle.size() + " g\u00fcltige Eintr\u00e4ge, die nicht in die Baumstruktur passten!\n(Siehe Knoten Fehler)", "SuperX Admin", 2);
            this.log(String.valueOf(problemf\u00e4lle.size()) + " g\u00fcltige Eintr\u00e4ge, die nicht in die Baumstruktur passten:");
            DefaultMutableTreeNode fehlernode = new DefaultMutableTreeNode("Fehler");
            Enumeration el = problemf\u00e4lle.elements();
            while (el.hasMoreElements()) {
                x = (OrgaEintrag2)el.nextElement();
                fehlernode.add(new DefaultMutableTreeNode(x));
                this.log(String.valueOf(x.getKeyApnr()) + " - " + x.getName() + "parent (" + x.getParent() + ")");
            }
            root.add(fehlernode);
        }
    }

    public void setGewaehlt(OrgaEintrag2 was) {
        this.gewaehlt = was;
    }

    public void speichern() {
        int i2 = 0;
        Object ins = null;
        StringBuffer sql = new StringBuffer("create  table tmp_organigramm(tid serial not null ,key_apnr char(10),parent char(10),drucktext char(150),name char(150),ebene integer,lehre smallint,gueltig_seit date not null ,gueltig_bis date not null ,orgstruktur integer);");
        Object wo = null;
        WindowUtils.setWaitCursor(this, true);
        try {
            OrgaEintrag2 x;
            DefaultMutableTreeNode lroot = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            DBAccess.executeUpdate("delete from organigramm where 1=1");
            Enumeration<Object> en = this.merkung\u00fcltig.elements();
            while (en.hasMoreElements()) {
                x = (OrgaEintrag2)en.nextElement();
                ++i2;
                sql.append(this.getInsertCommand(x));
            }
            try {
                DBAccess.executeUpdateAll(sql.toString());
            }
            catch (SQLException e2) {
                System.out.println("Fehler beim Schreiben eines Orga-Eintrags in die Datenbank:\n " + e2.toString());
                throw new SQLException();
            }
            catch (Exception e3) {
                System.out.println("Fehler beim Schreiben eines Orga-Eintrags in die Datenbank:\n " + e3.toString());
                throw new Exception();
            }
            DefaultMutableTreeNode aNode = null;
            sql = new StringBuffer();
            en = lroot.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode vorher = aNode;
                aNode = (DefaultMutableTreeNode)en.nextElement();
                if (aNode.toString().equals("Fehler")) continue;
                x = (OrgaEintrag2)aNode.getUserObject();
                if (!x.getName().equals("Hochschule")) {
                    TreePath tp = new TreePath(aNode.getUserObjectPath());
                    String string = x.getKeyApnr();
                }
                if (x.getKeyApnr() != null) {
                    sql.append(this.getInsertCommand(x));
                }
                ++i2;
            }
            try {
                sql.append("insert into organigramm select * from tmp_organigramm;\tdrop table tmp_organigramm;");
                DBAccess.executeUpdateAll(sql.toString());
            }
            catch (SQLException e4) {
                System.out.println("Fehler beim Schreiben eines Problemfalls in die Datenbank:\n " + e4.toString());
                throw new SQLException();
            }
            catch (Exception e5) {
                System.out.println("Fehler beim Schreiben eines Problemfalls in die Datenbank:\n " + e5.toString());
                throw new Exception();
            }
            SuperXDBAdmin.setStatus(String.valueOf(i2 - 1) + " Eintr\u00e4ge ins Organigramm geschrieben");
        }
        catch (SQLException e6) {
            JOptionPane.showMessageDialog(null, "Fehler beim Schreiben in die Datenbank (siehe Java-Konsole):\n " + e6.toString(), "SuperX DB Admin", 2);
        }
        catch (Exception e7) {
            JOptionPane.showMessageDialog(null, "Allgemeiner Fehler beim Schreiben in die Datenbank (siehe Java-Konsole):\n " + e7.toString(), "SuperX DB Admin", 2);
        }
        this.setSaveNecessary(false);
        WindowUtils.setWaitCursor(this, false);
    }

    public boolean isSaveNecessary() {
        return this.isSaveNecessary;
    }

    private void setSaveNecessary(boolean mussNochSpeichern) {
        this.isSaveNecessary = mussNochSpeichern;
    }

    private String getInsertCommand(OrgaEintrag2 x) {
        String drucktext;
        String name = x.getName();
        if (name != null) {
            name = name.replaceAll("'", "''");
        }
        if ((drucktext = x.getName()) != null) {
            drucktext = drucktext.replaceAll("'", "''");
        }
        String ins = this.sx_db.equals("Postgres") ? "insert into tmp_organigramm (name,drucktext,key_apnr,ebene,parent,lehre,orgstruktur,gueltig_seit,gueltig_bis) values ('" + name + "','" + drucktext + "','" + x.getKeyApnr() + "'," + x.getEbene() + ",'" + x.getParent() + "'," + x.getLehre() + "," + x.getOrgstruktur() + ",date_val('" + SxUtils.GetValueAsString(x.getGueltigSeit()) + "'),date_val('" + SxUtils.GetValueAsString(x.getGueltigBis()) + "')); \n" : new String("insert into tmp_organigramm (name,drucktext,key_apnr,ebene,parent,lehre,orgstruktur,gueltig_seit,gueltig_bis) values ('" + name + "','" + drucktext + "','" + x.getKeyApnr() + "'," + x.getEbene() + ",'" + x.getParent() + "'," + x.getLehre() + "," + x.getOrgstruktur() + ",date(\"" + SxUtils.GetValueAsString(x.getGueltigSeit()) + "\"),date(\"" + SxUtils.GetValueAsString(x.getGueltigBis()) + "\"));\n ");
        return ins;
    }

    private void suchen() {
        DefaultMutableTreeNode test;
        String such = this.suchtext.getText().toLowerCase();
        boolean gefunden = false;
        DefaultMutableTreeNode ausgesucht = null;
        Vector<String> treffer = new Vector<String>();
        Vector<DefaultMutableTreeNode> treffernodes = new Vector<DefaultMutableTreeNode>();
        if (such.length() < 1) {
            JOptionPane.showMessageDialog(null, "Bitte Suchbegriff eingeben!", "SuperX", 1);
            return;
        }
        such = such.toLowerCase();
        this.root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            test = (DefaultMutableTreeNode)en.nextElement();
            String teststring = test.toString().toLowerCase();
            if (teststring.indexOf(such) <= -1) continue;
            treffer.addElement(test.toString());
            treffernodes.addElement(test);
        }
        if (treffer.size() > 0) {
            TreePath tp;
            if (treffer.size() > 1) {
                Object[] trefferstring = new String[treffer.size()];
                treffer.copyInto(trefferstring);
                String selectedValue = (String)JOptionPane.showInputDialog(null, "Mehrere Treffer!\nBitte ausw\u00e4hlen...", "SuperX", 1, null, trefferstring, trefferstring[0]);
                if (selectedValue == null) {
                    return;
                }
                gefunden = false;
                en = treffernodes.elements();
                while (en.hasMoreElements() && !gefunden) {
                    test = (DefaultMutableTreeNode)en.nextElement();
                    if (!test.toString().equals(selectedValue)) continue;
                    ausgesucht = test;
                    gefunden = true;
                }
            }
            if (ausgesucht == null) {
                ausgesucht = (DefaultMutableTreeNode)treffernodes.elementAt(0);
            }
            this.tree.clearSelection();
            en = this.root.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                test = (DefaultMutableTreeNode)en.nextElement();
                tp = new TreePath(test.getPath());
                if (!this.tree.isExpanded(tp)) continue;
                this.tree.collapsePath(tp);
            }
            tp = new TreePath(ausgesucht.getPath());
            this.tree.addSelectionPath(tp);
        } else {
            JOptionPane.showMessageDialog(null, "Keine Treffer", "SuperX", 1);
        }
    }

    void readTreeFromDb() {
        try {
            boolean i2 = false;
            this.orga = new Vector();
            this.merkung\u00fcltig = new Vector();
            Date gueltig_seit = null;
            Date gueltig_bis = null;
            String query = "SELECT name,drucktext,key_apnr,ebene,parent,lehre,gueltig_seit,gueltig_bis,orgstruktur FROM organigramm order by name";
            int validCount = 0;
            int errorCount = 0;
            Vector erg = DBAccess.executeQuery(query);
            this.entryCount = 0;
            Date StandDate = AdminOrga.getDate(this.standDatum);
            Enumeration el = erg.elements();
            while (el.hasMoreElements()) {
                Vector help = (Vector)el.nextElement();
                String name = help.get(0).toString();
                String drucktext = help.get(1).toString();
                String key_apnr = (String)help.get(2);
                Integer ebene = (Integer)help.get(3);
                String parent = (String)help.get(4);
                Object helpx = help.get(5);
                if (key_apnr.equals(parent)) {
                    ++errorCount;
                    this.log("Eintrag hat sich selbst als parent: " + key_apnr);
                }
                Integer lehre = new Integer(helpx.toString());
                Integer orgstruktur = (Integer)help.get(8);
                gueltig_seit = (Date)help.get(6);
                gueltig_bis = (Date)help.get(7);
                this.einEintrag = new OrgaEintrag2(name, drucktext, key_apnr, ebene, parent, lehre, gueltig_seit, gueltig_bis, orgstruktur);
                if ((gueltig_seit.equals(StandDate) || gueltig_seit.before(StandDate)) && (gueltig_bis.equals(StandDate) || gueltig_bis.after(StandDate))) {
                    this.orga.addElement(this.einEintrag);
                    ++validCount;
                } else {
                    this.merkung\u00fcltig.addElement(this.einEintrag);
                }
                ++this.entryCount;
            }
            if (errorCount > 0) {
                JOptionPane.showMessageDialog(null, "Achtung!\n" + errorCount + " Eintr\u00e4ge haben sich selbst als parent!", "SuperX Admin", 2);
            }
            OrgaEintrag2 hochschule = new OrgaEintrag2("Hochschule", null, null, null, null, null, null, null, null);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(hochschule);
            this.insertnodes("", root);
            int treeNodeCount = this.getChildCount(root);
            if (validCount != treeNodeCount) {
                this.pr\u00fcfeDifferenzen(root);
            }
            this.treeModel = new DefaultTreeModel(root);
            this.tree.setModel(this.treeModel);
            DefaultMutableTreeNode ebene1 = (DefaultMutableTreeNode)root.getChildAt(0);
            this.tree.expandPath(new TreePath(ebene1.getPath()));
            this.tree.getSelectionModel().setSelectionMode(1);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setBorderSelectionColor(Color.darkGray);
            this.tree.setCellRenderer(renderer);
            AdminOrgaSelList adosl = new AdminOrgaSelList(this, this.tree);
            this.tree.addTreeSelectionListener(adosl);
            this.tree.addKeyListener(this);
            AdminOrgaMouseListener ml = new AdminOrgaMouseListener(this, this.tree, this.merkung\u00fcltig);
            this.tree.addMouseListener(ml);
            SuperXDBAdmin.setStatus(String.valueOf(this.entryCount) + " OrgaEintr\u00e4ge eingelesen");
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Fehler beim Lesen aus der Datenbank: " + e2.toString(), "SuperX DB Admin", 2);
            e2.printStackTrace();
        }
        WindowUtils.setWaitCursor(this, false);
        this.validate();
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 127) {
            this.l\u00f6schenNode();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (event.getKeyCode() == 127) {
            this.l\u00f6schenNode();
        }
    }
}

