/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.ImageAndRtfTransferable;
import de.memtext.util.ImageTransferable;
import de.memtext.util.RtfTransferable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class ClipboardUtils {
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();

    private ClipboardUtils() {
    }

    public static boolean setContents(StringBuffer content, ClipboardOwner owner) {
        return ClipboardUtils.setContents(content.toString(), owner);
    }

    public static boolean setContents(Image image, ClipboardOwner owner) {
        return ClipboardUtils.setContents(new ImageTransferable(image), owner);
    }

    public static boolean setContents(String content, ClipboardOwner owner) {
        return ClipboardUtils.setContents(new StringSelection(content), null);
    }

    public static boolean setImageContents(Component comp, ClipboardOwner owner) {
        return ClipboardUtils.setContents(new ImageTransferable(comp), owner);
    }

    public static void setImageAndRtfContents(Image image, ByteArrayOutputStream outStream, ClipboardOwner owner) {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(outStream.toByteArray());
        ClipboardUtils.setContents(new ImageAndRtfTransferable(image, byteInputStream), owner);
    }

    public static void setRtfContents(ByteArrayOutputStream outStream, ClipboardOwner owner) {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(outStream.toByteArray());
        ClipboardUtils.setContents(new RtfTransferable(byteInputStream), owner);
    }

    public static boolean setContents(Transferable contents, ClipboardOwner owner) {
        boolean result = true;
        try {
            CLIPBOARD.setContents(contents, owner);
        }
        catch (IllegalStateException e2) {
            ClipboardUtils.showWarning(e2);
            result = false;
        }
        return result;
    }

    public static BufferedImage toBufferedImage(Component comp) {
        BufferedImage tempImage = new BufferedImage(comp.getSize().width, comp.getSize().height, 1);
        Graphics tempGraphics = tempImage.getGraphics();
        Graphics2D g2d = (Graphics2D)tempImage.getGraphics();
        comp.paint(tempGraphics);
        return tempImage;
    }

    public static byte[] toByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", outstream);
        return outstream.toByteArray();
    }

    private static void showWarning(Exception e2) {
        JOptionPane.showMessageDialog(null, "Couldn't copy to clipboard.\n" + e2.toString(), "Problem", 2);
    }

    public static Object getContents() {
        Transferable result;
        String[] s = ImageIO.getWriterFormatNames();
        int i2 = 0;
        while (i2 < s.length) {
            System.out.println(s[i2]);
            ++i2;
        }
        System.exit(-1);
        Transferable t = result = CLIPBOARD.getContents(null);
        DataFlavor[] d2 = t.getTransferDataFlavors();
        int i3 = 1;
        while (i3 < d2.length) {
            System.out.println(d2[i3]);
            ++i3;
        }
        try {
            Object o = t.getTransferData(new DataFlavor("text/rtf;representationclass=java.io.InputStream"));
            boolean i4 = true;
        }
        catch (UnsupportedFlavorException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (ClassNotFoundException e4) {
            e4.printStackTrace();
        }
        boolean i22 = true;
        return result;
    }

    public static void main(String[] args) {
        ClipboardUtils.test();
    }

    private static void test() {
        try {
            Transferable data = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            DataFlavor[] df = data.getTransferDataFlavors();
            int i2 = 0;
            while (i2 < df.length) {
                System.out.println(String.valueOf(df[i2].getHumanPresentableName()) + "   " + df[i2].getMimeType());
                ++i2;
            }
        }
        catch (Throwable ta) {
            ta.printStackTrace();
        }
    }
}

