/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.tree.admin.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class Entry
implements Cloneable {
    private boolean debug = false;
    private Field keyfield;
    private Field parentfield;
    private String name;
    private final Map fields = new HashMap();

    public void setKeyfield(Field keyfield) {
        this.keyfield = keyfield;
    }

    public void setParentfield(Field parentfield) {
        this.parentfield = parentfield;
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public void setValue(String fieldname, Object value) {
        Field field = (Field)this.fields.get(fieldname);
        field.setValue(value);
    }

    public Object getValue(Object fieldname) {
        Field field = (Field)this.fields.get(fieldname);
        return field.getValue();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getKey() {
        return this.keyfield.getValue();
    }

    public void setKey(Object key) {
        this.keyfield.setValue(key);
    }

    public Object getParent() {
        return this.parentfield.getValue();
    }

    public void setParent(Object parent) {
        this.parentfield.setValue(parent);
    }

    public int getSpecialFieldCount() {
        return this.fields.size();
    }

    public Iterator fieldNameIterator() {
        Set fieldkeys = this.fields.keySet();
        return fieldkeys.iterator();
    }

    public Iterator fieldIterator() {
        Collection c2 = this.fields.values();
        return c2.iterator();
    }

    public String toString() {
        String result = null;
        if (this.debug) {
            result = "Entry name:" + this.getName() + " key:" + this.getKey() + " parent:" + this.getParent() + " " + this.fields.size() + " fields:";
            Set fieldkeys = this.fields.keySet();
            for (String key : fieldkeys) {
                Field f2 = (Field)this.fields.get(key);
                result = String.valueOf(result) + " " + key + " value:" + f2.getValue() + " ";
            }
        } else {
            result = this.getName();
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Entry result = new Entry();
        result.setKeyfield(new Field(this.keyfield.getName(), this.keyfield.getType()));
        result.setParentfield(new Field(this.parentfield.getName(), this.parentfield.getType()));
        result.setName(this.getName());
        Set fieldkeys = this.fields.keySet();
        for (String key : fieldkeys) {
            Field f2 = (Field)this.fields.get(key);
            result.addField((Field)f2.clone());
        }
        return result;
    }
}

