/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

public class RestrictionCollector {
    private StringBuffer restrict = new StringBuffer();
    private int count = 0;

    public RestrictionCollector() {
    }

    public RestrictionCollector(String restriction) {
        this.restrict.append(restriction);
        this.count = 1;
    }

    public boolean isSomethingAdded() {
        return this.count > 0;
    }

    public void addAndRestriction(StringBuffer restriction) {
        this.addAndRestriction(restriction.toString());
    }

    public void addAndRestriction(String restriction) {
        if (restriction == null || restriction.length() < 3) {
            throw new IllegalArgumentException("Not OK:" + restriction);
        }
        boolean isNewlineAtStart = restriction.startsWith("\n");
        restriction = restriction.trim();
        if (isNewlineAtStart) {
            restriction = "\n" + restriction;
        }
        if (restriction.substring(0, 3).equalsIgnoreCase("and")) {
            restriction = restriction.substring(3);
        }
        if (this.count > 0) {
            this.restrict.append(" and " + restriction + " ");
        } else {
            this.restrict.append(String.valueOf(restriction) + " ");
        }
        ++this.count;
    }

    public void addOrRestriction(StringBuffer restriction) {
        this.addOrRestriction(restriction.toString());
    }

    public void addOrRestriction(String restriction) {
        if (restriction == null || restriction.length() < 3) {
            throw new IllegalArgumentException("Not OK:" + restriction);
        }
        if ((restriction = restriction.trim()).substring(0, 3).equalsIgnoreCase("or ")) {
            restriction = restriction.substring(3);
        }
        if (this.count > 0) {
            this.restrict.append(" or " + restriction + " ");
        } else {
            this.restrict.append(String.valueOf(restriction) + " ");
        }
        ++this.count;
    }

    public void addOrRestriction(RestrictionCollector collector) {
        this.addOrRestriction(collector.toString());
    }

    public String toString() {
        if (this.count > 0) {
            return this.restrict.toString();
        }
        return "";
    }

    public String toStringInclusiveWhere() {
        if (this.count > 0) {
            return " where " + this.restrict;
        }
        return "";
    }

    public int getArgumentCount() {
        return this.count;
    }

    public void addAndRestriction(RestrictionCollector collector) {
        if (collector.getArgumentCount() > 1) {
            this.addAndRestriction(collector.toString());
        } else {
            this.addAndRestriction(collector.toString());
        }
    }

    public static void main(String[] args) {
        RestrictionCollector r = new RestrictionCollector();
        r.addAndRestriction("   AND 1=1");
        r.addAndRestriction("2=2");
        System.out.println(r);
    }
}

