/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.AbstractHsqlStandaloneMgrResources;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class HsqlStandaloneMgr {
    private static AbstractHsqlStandaloneMgrResources resources;

    private HsqlStandaloneMgr() {
    }

    private static void initResources() {
        String mypackage = "";
        mypackage = "de.memtext.db.";
        resources = (AbstractHsqlStandaloneMgrResources)ResourceBundle.getBundle(String.valueOf(mypackage) + "HsqlStandaloneMgrResources");
    }

    public static boolean isDatabaseOpen(String path, String databasename) {
        File lckFile = new File(String.valueOf(HsqlStandaloneMgr.getAdaptedPath(path)) + databasename + ".lck");
        return lckFile.exists();
    }

    public static void deleteTmpFiles(String url, String path, String databasename) {
        if (databasename.indexOf("_TMP_COPY") > -1) {
            throw new IllegalArgumentException("Please specifiy the name of the original database without _TMP_COPY");
        }
        path = HsqlStandaloneMgr.getAdaptedPath(path);
        int tmpPos = url.indexOf("_TMP_COPY");
        if (tmpPos == -1) {
            File f2 = new File(String.valueOf(path) + databasename + "_user.properties");
            if (f2.exists()) {
                f2.delete();
            }
        } else {
            String tmp = url.substring(tmpPos);
            if (path == null || path.equals("")) {
                path = ".";
            }
            File fpath = new File(path);
            File[] tmpFiles = fpath.listFiles(new TmpFileFilter(String.valueOf(databasename) + tmp));
            int i2 = 0;
            while (i2 < tmpFiles.length) {
                tmpFiles[i2].delete();
                ++i2;
            }
        }
    }

    public static int askUser(Component parentComponent, String path, String databasename, boolean isReadOnlyCopyWanted) {
        if (resources == null) {
            HsqlStandaloneMgr.initResources();
        }
        String username = null;
        File f2 = new File(String.valueOf(HsqlStandaloneMgr.getAdaptedPath(path)) + databasename + "_user.properties");
        if (f2.exists()) {
            Properties p = new Properties();
            try {
                FileInputStream fis = new FileInputStream(f2);
                p.load(fis);
                username = p.getProperty("user");
                fis.close();
            }
            catch (Exception e2) {
                System.err.println(resources.getString("Couldn't read user name"));
                e2.printStackTrace();
            }
        }
        StringBuffer msg = new StringBuffer(resources.getDbInUseBy(databasename, username));
        if (isReadOnlyCopyWanted) {
            msg.append(resources.getString("Would you like to open a temporary copy in read-only mode?"));
        } else {
            msg.append(resources.getString("Would you like to open a temporary copy?\nAttention - any changes to the database will be lost after closing the program!"));
        }
        return JOptionPane.showConfirmDialog(parentComponent, msg, "HSQLDB", 0, 3);
    }

    public static Connection getTmpConnection(Component parentComponent, String path, String databasename, String username, String password, boolean isReadOnlyCopyWanted) throws ClassNotFoundException, SQLException, IOException {
        if (resources == null) {
            HsqlStandaloneMgr.initResources();
        }
        Class.forName("org.hsqldb.jdbcDriver");
        path = HsqlStandaloneMgr.getAdaptedPath(path);
        int tmpInstanceNumber = HsqlStandaloneMgr.checkNumber(path, databasename);
        try {
            HsqlStandaloneMgr.copyDatabaseFiles(path, databasename, tmpInstanceNumber);
        }
        catch (IOException e2) {
            JOptionPane.showMessageDialog(parentComponent, String.valueOf(resources.getString("Could not create temporary copy of database.)")) + "\n" + e2, "HSQLDB", 2);
            throw e2;
        }
        if (isReadOnlyCopyWanted) {
            try {
                HsqlStandaloneMgr.setReadonly(String.valueOf(path) + databasename + "_TMP_COPY" + tmpInstanceNumber + ".properties");
            }
            catch (IOException e3) {
                JOptionPane.showMessageDialog(parentComponent, String.valueOf(resources.getString("Could not set temporary copy of database to readonly mode.")) + "\n" + e3, "HSQLDB", 2);
                throw e3;
            }
        }
        String url = "jdbc:hsqldb:file:" + path + databasename + "_TMP_COPY" + tmpInstanceNumber;
        Connection con = DriverManager.getConnection(url, username, password);
        if (!isReadOnlyCopyWanted) {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from system_tables where hsqldb_type='TEXT'");
            rs.next();
            if (rs.getInt(1) > 0) {
                stmt.execute("shutdown");
                stmt.close();
                con.close();
                HsqlStandaloneMgr.deleteTmpFiles(url, path, databasename);
                throw new SQLException(resources.getString("Handling non read-only temporary database with text tables is not supported"));
            }
            rs.close();
            stmt.close();
        }
        return con;
    }

    private static int checkNumber(String path, String databasename) {
        int result = 1;
        while (new File(String.valueOf(path) + databasename + "_TMP_COPY" + result + ".script").exists()) {
            ++result;
        }
        return result;
    }

    public static Connection getConnection(String path, String databasename, String username, String password) throws ClassNotFoundException, SQLException, IOException {
        Class.forName("org.hsqldb.jdbcDriver");
        String url = null;
        url = path == null ? "jdbc:hsqldb:" + databasename : "jdbc:hsqldb:file:" + HsqlStandaloneMgr.getAdaptedPath(path) + databasename;
        Connection con = DriverManager.getConnection(url, username, password);
        Properties p = new Properties();
        p.put("user", System.getProperty("user.name"));
        String filename = path != null ? String.valueOf(path) + "/" + databasename + "_user.properties" : String.valueOf(databasename) + "_user.properties";
        FileOutputStream fos = new FileOutputStream(filename);
        p.store(fos, "User which uses the HSQL database");
        fos.close();
        return con;
    }

    private static String getAdaptedPath(String path) {
        if (path == null) {
            path = "";
        }
        if (!(!path.equals(".") && path.length() <= 1 || path.endsWith("/") || path.endsWith("\\"))) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    private static void setReadonly(String propertiesFile) throws IOException {
        Properties p = new Properties();
        p.load(new FileInputStream(propertiesFile));
        p.put("readonly", "true");
        p.store(new FileOutputStream(propertiesFile), "HSQL database");
    }

    private static void copyDatabaseFiles(String path, String databasename, int number) throws IOException {
        String s = String.valueOf(path) + databasename;
        HsqlStandaloneMgr.copyFile(String.valueOf(s) + ".script", String.valueOf(s) + "_TMP_COPY" + number + ".script");
        HsqlStandaloneMgr.copyFile(String.valueOf(s) + ".properties", String.valueOf(s) + "_TMP_COPY" + number + ".properties");
        if (new File(String.valueOf(s) + ".log").exists()) {
            HsqlStandaloneMgr.copyFile(String.valueOf(s) + ".log", String.valueOf(s) + "_TMP_COPY" + number + ".log");
        }
        if (new File(String.valueOf(s) + ".data").exists()) {
            HsqlStandaloneMgr.copyFile(String.valueOf(s) + ".data", String.valueOf(s) + "_TMP_COPY" + number + ".data");
        }
        if (new File(String.valueOf(s) + ".backup").exists()) {
            HsqlStandaloneMgr.copyFile(String.valueOf(s) + ".backup", String.valueOf(s) + "_TMP_COPY" + number + ".backup");
        }
        if (new File(String.valueOf(s) + ".nio").exists()) {
            HsqlStandaloneMgr.copyFile(String.valueOf(s) + ".nio", String.valueOf(s) + "_TMP_COPY" + number + ".nio");
        }
    }

    public static void copyFile(String source, String target) throws IOException {
        try {
            FileInputStream is = new FileInputStream(source);
            FileOutputStream os = new FileOutputStream(target);
            BufferedInputStream in = new BufferedInputStream(is);
            BufferedOutputStream out = new BufferedOutputStream(os);
            int buffer_size = 32768;
            byte[] buffer = new byte[buffer_size];
            int len = in.read(buffer, 0, buffer_size);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer, 0, buffer_size);
            }
            in.close();
            is.close();
            out.close();
            os.close();
        }
        catch (IOException e2) {
            throw new IOException("Couldn't copy file " + source + ": " + e2.toString());
        }
    }

    private static class TmpFileFilter
    implements FilenameFilter {
        private String tmpName;

        TmpFileFilter(String tmpName) {
            this.tmpName = tmpName;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(this.tmpName) > -1;
        }
    }
}

