/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.ConnectionCreator;
import de.memtext.db.DbRequest;
import de.memtext.db.DbResponse;
import de.memtext.db.DbServerI;
import de.memtext.db.DbUtils;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DbServerImpl
extends UnicastRemoteObject
implements DbServerI {
    private String dbDriver = "org.hsqldb.jdbcDriver";
    private String dbURL = "jdbc:hsqldb:hsql://localhost:9000";
    private String userid = "SA";
    private String passwd = "";
    private int updateRowCount;
    private Connection con;
    private Statement stmt;

    public DbServerImpl() throws RemoteException {
        ConnectionCreator.loadClass(this.dbDriver);
        try {
            this.con = ConnectionCreator.getConnection(this.dbURL, this.userid, this.passwd);
            this.stmt = this.con.createStatement();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RemoteException("Couldn't connect to DB" + e2.toString());
        }
    }

    @Override
    public DbResponse execute(String sql) throws RemoteException {
        DbResponse result = new DbResponse(null, true, null);
        try {
            this.updateRowCount = this.stmt.executeUpdate(sql);
            result.setUpdatedRowsCount(this.updateRowCount);
            result.setOK(true);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            result.setOK(false);
            result.setException(e2);
        }
        return result;
    }

    @Override
    public DbResponse execute(DbRequest dbRequest) throws RemoteException {
        DbResponse result = new DbResponse(null, true, null);
        if (dbRequest.getSql() != null) {
            result = this.execute(dbRequest.getSql());
        }
        return result;
    }

    @Override
    public DbResponse executeQuery(String sql) throws RemoteException {
        DbResponse result = new DbResponse(null, true, null);
        try {
            ResultSet rs = this.stmt.executeQuery(sql);
            List list = DbUtils.toResultList(rs);
            result.setResult(list);
            result.setOK(true);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            result.setOK(false);
            result.setException(e2);
        }
        return result;
    }

    @Override
    public DbResponse executeQuery(DbRequest dbRequest) throws RemoteException {
        DbResponse result = new DbResponse(null, true, null);
        result.setUpdatedRowsCount(20);
        return result;
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            DbServerImpl obj = new DbServerImpl();
            String name = "DbServer";
            Naming.rebind(name, obj);
            System.out.println(String.valueOf(name) + " bound in registry");
        }
        catch (Exception e2) {
            System.out.println("DbServerImpl err: " + e2.getMessage());
            e2.printStackTrace();
        }
    }
}

