/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.baseobjects.NamedIdObjectWithParentI;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.time.EphemeralI;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeBuilder;
import de.memtext.tree.TreeEntryNode;
import de.memtext.util.TreeUtils;
import de.superx.common.DBServletException;
import de.superx.common.Maske;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.ThemenbaumI;
import de.superx.common.TransletCache;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Themenbaum
implements ThemenbaumI,
Serializable {
    private static final long serialVersionUID = 1L;
    Integer userid;
    String login_name;
    boolean isAdmin;
    private StringBuffer menuXml;
    private String menuHtml;
    private String mandantenID = "default";
    private Menu menu;

    @Override
    public synchronized void init(Integer userid, String login_name, boolean isAdmin, String mandantenID) throws SQLException, DBServletException, TransformerException, NichtAngemeldetException {
        this.userid = userid;
        this.login_name = login_name;
        this.mandantenID = mandantenID;
        this.isAdmin = isAdmin;
        try {
            this.menuXml = this.getMenuXmlAndInitMenu();
        }
        catch (KeyParentEqualException e) {
            throw new SQLException("Themenbaum defekt. DETAILS: Ein Eintrag hat key=parent " + e.getMessage());
        }
        catch (NoMainEntryException e) {
            throw new SQLException("Im Themenbaum kein Hauptknoten gefunden DETAILS:mit parent null" + e);
        }
    }

    private void transform() throws TransformerException, TransformerConfigurationException, DBServletException {
        Transformer transformer = TransletCache.getTransformer(this.mandantenID, "file:///" + ServletUtils.getPath() + "/menue_html.xsl");
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(this.menuXml.toString())), new StreamResult(erg));
        this.menuHtml = erg.toString();
    }

    private StringBuffer getMenuXmlAndInitMenu() throws SQLException, DBServletException, KeyParentEqualException, NoMainEntryException, NichtAngemeldetException {
        StringBuffer result = new StringBuffer();
        result.append("<menue hisinone_active=\"" + (SuperXManager.isHis1 ? "true" : "false") + "\"\nhisinone_refapp=\"" + SuperXManager.his1_refapp + "\" showNavigation=\"true\"");
        if (SxPools.get(this.mandantenID).getRepository().containsKey("K_aufklappbarer Themenbaum") && SxPools.get(this.mandantenID).getRepository().get("K_aufklappbarer Themenbaum").toString().equals("1")) {
            result.append(" aufklappbarer_themenbaum=\"true\"");
        }
        result.append(">");
        result.append(Maske.addGeneralInfo());
        result.append(ServletUtils.addCustomElementsToXml(this.mandantenID));
        String welcomedPerson = this.login_name;
        if (this.login_name == null || this.login_name.trim().equals("")) {
            welcomedPerson = this.userid.toString();
        }
        result.append("<nachricht>" + welcomedPerson + "</nachricht>");
        String query = SxPools.get(this.mandantenID).getSqlDialect().equals("Postgres") ? "select sp_user_themen(" + this.userid.toString() + ",today(),1);select distinct tid,name,maskeninfo_id,parent,erlaeuterung,sort,css_class from tmp_themenbaum order by sort,name; drop table tmp_themenbaum;" : (SxPools.get(this.mandantenID).getSqlDialect().equals("Informix") ? "execute procedure sp_user_themen(" + this.userid.toString() + ",today,1);select distinct tid,name,maskeninfo_id,parent,erlaeuterung,sort,css_class from tmp_themenbaum order by sort,name; drop table tmp_themenbaum;" : "select tid, name, maskeninfo_id, parent, gueltig_seit, gueltig_bis,sort,css_class from themenbaum order by sort,name;");
        SuperX_el erg_el = ServletUtils.executeALL_el(null, null, "Themenbaum auslesen", query, this.mandantenID, true);
        if (erg_el.getResultSet().size() == 0) {
            throw new NichtAngemeldetException("Keine Berechtigungen f\u00fcr Berichte gefunden");
        }
        Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, "Abfrage: " + query);
        result.append("<userid>" + this.userid.toString() + "</userid>");
        result.append("<mandantenid>" + this.mandantenID + "</mandantenid>");
        result.append("<eintraege>\n");
        int zeile = 0;
        HashMap map = new HashMap();
        for (SxResultRow row : erg_el.getResultSet()) {
            String isMaske = "false";
            if (row.get(2) != null) {
                isMaske = "true";
            }
            result.append("<eintrag isMaske=\"" + isMaske + "\">\n<zeile>" + (zeile + 1) + "</zeile>\n<!--id = tid in themenbaumtabelle -->\n<id>" + row.get(0) + "</id>\n<!--tid = tid in maskeninfo-tabelle -->\n<tid>" + row.get(2) + "</tid>\n<titel><![CDATA[" + row.get(1) + "]]></titel>\n<parent>" + row.get(3) + "</parent>\n<sort>" + row.get(5) + "</sort>\n<css_class>" + row.get(6) + "</css_class>\n</eintrag>\n");
            MenuItemNode n = new MenuItemNode(new NamedIdObjectWithParent(row.get(0), (String)row.get(1), row.get(3)));
            n.setMaskenID((Integer)row.get(2));
            n.setErlaeuterung((String)row.get(4));
            if (row.get(5) != null) {
                n.setSortnr(new Integer(row.get(5).toString()));
            }
            n.setCssClass((String)row.get(6));
            TreeBuilder.add(map, n);
        }
        MenuItemNode root = new MenuItemNode(new NamedIdObjectWithParent("xxxxx", "xxxxx", null));
        TreeBuilder.addNodesToRootFromMap(root, map, new Date());
        this.menu = new Menu(root);
        result.append("</eintraege>\n");
        result.append("</menue>");
        Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "Themenbaum XML " + result);
        return result;
    }

    @Override
    public String getSubmenuXml(String tid, String navigationElement) {
        if (tid == null) {
            throw new IllegalArgumentException("Keine Tid angegeben");
        }
        return this.menu.getSubmenuXml(tid, navigationElement);
    }

    @Override
    public String getMenupath(String tid) {
        if (tid == null) {
            throw new IllegalArgumentException("Keine Tid angegeben");
        }
        return this.menu.getMenupathForMask(tid);
    }

    @Override
    public String toHtml(Locale locale) {
        Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "Versuche Themenbaum HTML Transformation");
        try {
            this.transform();
        }
        catch (TransformerException e) {
            Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.SEVERE, "Themenbaum HTML Transformation fehlgeschlagen:  " + e.toString());
        }
        catch (DBServletException e) {
            Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.SEVERE, "Themenbaum HTML Auslesen fehlgeschlagen:  " + e.toString());
        }
        Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "Themenbaum HTML Transformation erfolgreich");
        String result = SxPools.get(this.mandantenID).localize(this.menuHtml, locale).replaceAll("_HISINONE_", SuperXManager.his1_refapp);
        Logger.getLogger("superx_" + this.mandantenID + "_xml").log(Level.FINE, "Themenbaum HTML  _HISINONE_ ersetzt durch " + SuperXManager.his1_refapp + "\n" + result);
        return result;
    }

    @Override
    public String toXml(Locale locale) {
        String myXml = this.menuXml.toString();
        String result = SxPools.get(this.mandantenID).localize(myXml, locale);
        return result;
    }

    private class MenuItemNode
    extends TreeEntryNode
    implements Comparable,
    EphemeralI {
        private static final long serialVersionUID = 1L;
        private Integer sortnr;
        private Integer maskenID;
        private String erlaeuterung;
        private String cssClass;

        public MenuItemNode(NamedIdObjectWithParentI namedIdObjectWithParentI) {
            super(namedIdObjectWithParentI);
            this.sortnr = new Integer(0);
        }

        public Integer getSortnr() {
            return this.sortnr;
        }

        public void setSortnr(Integer sortnr) {
            this.sortnr = sortnr;
        }

        public Integer getMaskenID() {
            return this.maskenID;
        }

        public void setMaskenID(Integer maskenID) {
            this.maskenID = maskenID;
        }

        public String getErlaeuterung() {
            return this.erlaeuterung;
        }

        public void setErlaeuterung(String erlaeuterung) {
            this.erlaeuterung = erlaeuterung;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public void setCssClass(String cssClass) {
            this.cssClass = cssClass;
        }

        public int compareTo(Object o) {
            int result = 0;
            MenuItemNode n = (MenuItemNode)o;
            result = n.getSortnr().equals(this.getSortnr()) ? this.getName().compareTo(n.getName()) : this.getSortnr().compareTo(n.getSortnr());
            return result;
        }

        @Override
        public Date getValidSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getValidTill() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidAt(Date date) {
            return true;
        }

        @Override
        public void setValidSince(Date date) {
        }

        @Override
        public void setValidTill(Date date) {
            throw new UnsupportedOperationException();
        }

        public String toXml() {
            StringBuffer result = new StringBuffer();
            String isMaske = "false";
            if (this.getMaskenID() != null) {
                isMaske = "true";
            }
            result.append("<eintrag isMaske=\"" + isMaske + "\">\n<id>" + this.getId() + "</id>\n<tid>" + this.getMaskenID() + "</tid>\n<titel><![CDATA[" + this.getName() + "]]></titel>\n<parent>" + this.getParent() + "</parent>\n<explanation><![CDATA[" + this.getErlaeuterung() + "]]></explanation>\n<sort>" + this.getSortnr() + "</sort>\n<css_class>\n" + this.getCssClass() + "</css_class>\n</eintrag>\n");
            return result.toString();
        }
    }

    private class Menu
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;
        private boolean aufklappbarerThemenbaum;

        public Menu(MenuItemNode root) {
            super(root);
            this.aufklappbarerThemenbaum = false;
        }

        public void printout() {
            System.out.println(TreeUtils.toString((DefaultMutableTreeNode)this.getRoot()));
        }

        public String getMenupathForMask(String id) {
            MenuItemNode n = this.getNodeforMask(id);
            return this.getMenupath(n);
        }

        public String getMenupathForTid(String tid) {
            MenuItemNode n = this.getNode(tid);
            return this.getMenupath(n);
        }

        public boolean isAufklappbarerThemenbaum() {
            return this.aufklappbarerThemenbaum;
        }

        public void setAufklappbarerThemenbaum(boolean aufklappbarerThemenbaum) {
            this.aufklappbarerThemenbaum = aufklappbarerThemenbaum;
        }

        private String getMenupath(MenuItemNode n) {
            StringBuffer result = new StringBuffer("<menupos>\n<eintraege>\n");
            if (n != null) {
                TreeNode[] tp = n.getPath();
                for (int i = 1; i < tp.length; ++i) {
                    MenuItemNode node = (MenuItemNode)tp[i];
                    if (node.isLeaf()) continue;
                    result.append(node.toXml());
                }
            }
            result.append("\n</eintraege>\n</menupos>");
            return result.toString();
        }

        private MenuItemNode getNodeforMask(String id) {
            MenuItemNode r = null;
            Enumeration<TreeNode> en = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                MenuItemNode n = (MenuItemNode)en.nextElement();
                if (n.getMaskenID() == null || !n.getMaskenID().toString().equals(id)) continue;
                r = n;
                break;
            }
            return r;
        }

        private MenuItemNode getNode(String tid) {
            MenuItemNode r = null;
            Enumeration<TreeNode> en = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                MenuItemNode n = (MenuItemNode)en.nextElement();
                if (!n.getId().toString().equals(tid)) continue;
                r = n;
                break;
            }
            if (r == null) {
                throw new IllegalArgumentException("Kein Eintrag im Menue f\u00fcr Themenbaum tid=" + tid + " gefunden");
            }
            return r;
        }

        public String getSubmenuXml(String tid, String navigationElement) {
            boolean showNavigation = !navigationElement.isEmpty();
            StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + SqlStringUtils.getEncoding() + "\"?>\n<menue hisinone_active=\"" + (SuperXManager.isHis1 ? "true" : "false") + "\"  hisinone_refapp=\"" + SuperXManager.his1_refapp + "\" showNavigation=\"" + showNavigation + "\"");
            if (SxPools.get(Themenbaum.this.mandantenID).getRepository().containsKey("K_aufklappbarer Themenbaum") && SxPools.get(Themenbaum.this.mandantenID).getRepository().get("K_aufklappbarer Themenbaum").toString().equals("1")) {
                result.append(" aufklappbarer_themenbaum=\"true\"");
            }
            result.append(">\n");
            result.append(Maske.addGeneralInfo());
            result.append(ServletUtils.addCustomElementsToXml(Themenbaum.this.mandantenID));
            result.append("<user id=\"" + Themenbaum.this.userid + "\" admin=\"" + (Themenbaum.this.isAdmin ? "true" : "false") + "\"><![CDATA[" + Themenbaum.this.login_name + "]]></user>\n");
            if (showNavigation) {
                result.append(navigationElement);
            }
            MenuItemNode n = this.getNode(tid);
            result.append(this.getMenupathForTid(tid));
            result.append("<eintraege>\n<!--id = tid in themenbaumtabelle -->\n<!--tid = tid in maskeninfo-tabelle -->\n");
            Enumeration<TreeNode> en2 = n.children();
            while (en2.hasMoreElements()) {
                MenuItemNode n2 = (MenuItemNode)en2.nextElement();
                if (n2.getId().toString().equals(tid)) continue;
                result.append(n2.toXml());
            }
            result.append("\n</eintraege>\n</menue>");
            return result.toString();
        }
    }
}

