/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.db.RestrictionCollector;
import de.memtext.util.StringUtils;
import de.superx.common.Field;
import de.superx.common.RightsApplicator;
import de.superx.common.SxResultRow;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class SxKontierungsrechte
implements TemplateMethodModelEx,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String readingSQL = "select finanzstelle,hhprog,fonds,fipos from gxstage_user_rights where userinfo_id=";
    private boolean hasAllRights = false;
    private List<SxKontierungsrecht> rechteSammlung = new LinkedList<SxKontierungsrecht>();

    public void setHasAllRights(boolean hasAllRights) {
        this.hasAllRights = hasAllRights;
    }

    public Object exec(List l) throws TemplateModelException {
        String method = l.get(0).toString();
        StringBuffer result = new StringBuffer();
        if (method.equals("getSQL")) {
            this.getSQL(l, result);
        }
        if (method.equals("getHHProgAuswahl")) {
            this.getHHProgAuswahl(result);
        }
        if (method.equals("getFondsAuswahl")) {
            this.getFondsAuswahl(result);
        }
        return result.toString();
    }

    private void getHHProgAuswahl(StringBuffer result) throws TemplateModelException {
        if (this.hasAllRights || this.hasAllHHProgRights()) {
            result.append("1=1 --alle HHProg\n");
        } else {
            RestrictionCollector rc = new RestrictionCollector();
            for (SxKontierungsrecht kr : this.rechteSammlung) {
                rc.addOrRestriction(kr.getAuswahl(1, "apnr"));
            }
            result.append("( " + rc.toString() + ")");
        }
    }

    private boolean hasAllHHProgRights() {
        boolean result = false;
        for (SxKontierungsrecht kr : this.rechteSammlung) {
            if (!kr.getHHprog().equals("0")) continue;
            result = true;
        }
        return result;
    }

    private boolean hasAllFondsRights() {
        boolean result = false;
        for (SxKontierungsrecht kr : this.rechteSammlung) {
            if (!kr.getFonds().equals("0")) continue;
            result = true;
        }
        return result;
    }

    private void getFondsAuswahl(StringBuffer result) throws TemplateModelException {
        if (this.hasAllRights || this.hasAllFondsRights()) {
            result.append("1=1 --alle Fonds\n");
        } else {
            RestrictionCollector rc = new RestrictionCollector();
            for (SxKontierungsrecht kr : this.rechteSammlung) {
                rc.addOrRestriction(kr.getAuswahl(2, "ggnr"));
            }
            result.append("( " + rc.toString() + ")");
        }
    }

    private void getSQL(List l, StringBuffer result) throws TemplateModelException {
        if (this.hasAllRights) {
            result.append("1=1 --alle Kontierungen\n");
        } else {
            this.addRechteEinschraenkung(l, result);
        }
    }

    private void addRechteEinschraenkung(List l, StringBuffer result) throws TemplateModelException {
        Field finanzstelleField = null;
        Field hhprogField = null;
        Field fondsField = null;
        Field fiposField = null;
        if (l.get(1) instanceof Field) {
            finanzstelleField = (Field)l.get(1);
        }
        if (l.get(2) instanceof Field) {
            hhprogField = (Field)l.get(2);
        }
        if (l.get(3) instanceof Field) {
            fondsField = (Field)l.get(3);
        }
        if (l.get(4) instanceof Field) {
            fiposField = (Field)l.get(4);
        }
        if (finanzstelleField == null) {
            throw new IllegalStateException("Kein Feld Finanzstelle gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        if (hhprogField == null) {
            throw new IllegalStateException("Kein Feld Haushaltsprogramm gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        if (fondsField == null) {
            throw new IllegalStateException("Kein Feld Fonds gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        if (fiposField == null) {
            throw new IllegalStateException("Kein Feld Finanzposition gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        RestrictionCollector rc = new RestrictionCollector();
        for (SxKontierungsrecht kr : this.rechteSammlung) {
            String r = kr.getSQL(finanzstelleField, hhprogField, fondsField, fiposField);
            if (r.equals("")) continue;
            rc.addOrRestriction(r);
        }
        if (!rc.isSomethingAdded()) {
            throw new IllegalStateException("Keine Berechtigung fuer gewaehlten Stand eines Felds (Finanzstelle/HHProg/Fonds/Finanzposition gefunden");
        }
        result.append("( " + rc.toString() + ")");
    }

    public void createAndAddEntry(SxResultRow row) {
        SxKontierungsrecht kr = new SxKontierungsrecht(row);
        if (kr.hasAllRights()) {
            this.hasAllRights = true;
        }
        this.rechteSammlung.add(kr);
    }

    public void clearAll() {
        this.hasAllRights = false;
        this.rechteSammlung.clear();
    }

    private class SxKontierungsrecht {
        private String finanzstelle;
        private String hhprog;
        private String fonds;
        private String fipos;
        private List arglist = new LinkedList();

        SxKontierungsrecht(SxResultRow row) {
            this.finanzstelle = (String)row.get(0);
            this.hhprog = (String)row.get(1);
            this.fonds = (String)row.get(2);
            this.fipos = (String)row.get(3);
            this.arglist.add("getSubkeys");
            this.arglist.add("dummy");
        }

        public String getHHprog() {
            return this.hhprog;
        }

        public String getFonds() {
            return this.fonds;
        }

        public String getSQL(Field finanzstelleField, Field hhprogField, Field fondsField, Field fiposField) throws TemplateModelException {
            RestrictionCollector rc = new RestrictionCollector();
            String r = null;
            if (!this.finanzstelle.equals("0") && (r = this.getSingle(finanzstelleField, "kst_nr", this.finanzstelle)).length() > 0) {
                rc.addAndRestriction(r);
            }
            if (!this.hhprog.equals("0") && (r = this.getSingle(hhprogField, "ktr_nr", this.hhprog)).length() > 0) {
                rc.addAndRestriction(r);
            }
            if (!this.fonds.equals("0") && (r = this.getSingle(fondsField, "ggnr", this.fonds)).length() > 0) {
                rc.addAndRestriction(r);
            }
            if (!this.fipos.equals("0") && (r = this.getSingle(fiposField, "sachkonto", this.fipos)).length() > 0) {
                rc.addAndRestriction(r);
            }
            String result = "";
            if (rc.isSomethingAdded()) {
                result = "( " + rc.toString() + "   )\n ";
            }
            return result;
        }

        public String getAuswahl(int field, String dbfieldname) throws TemplateModelException {
            String value = "";
            if (field == 1) {
                value = this.hhprog;
            }
            if (field == 2) {
                value = this.fonds;
            }
            RestrictionCollector rc = new RestrictionCollector();
            if (value.indexOf(",") > -1) {
                RightsApplicator.checkOnlyPosOrNeg(value);
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreElements()) {
                String einWert = st.nextToken();
                boolean isNegative = einWert.indexOf("-") > -1;
                if ((einWert = StringUtils.replace(einWert, "-", "")).indexOf("*") > -1) {
                    if (isNegative) {
                        rc.addAndRestriction(" " + dbfieldname + " not like '" + einWert.replace('*', '%') + "' ");
                        continue;
                    }
                    rc.addOrRestriction(" " + dbfieldname + "  like '" + einWert.replace('*', '%') + "' ");
                    continue;
                }
                if (isNegative) {
                    rc.addAndRestriction(" " + dbfieldname + " !='" + einWert + "' ");
                    continue;
                }
                rc.addOrRestriction(" " + dbfieldname + " ='" + einWert + "'");
            }
            return "(" + rc.toString() + ") ";
        }

        private String getSingle(Field field, String dbfieldname, String value) throws TemplateModelException {
            RestrictionCollector rc = new RestrictionCollector();
            if (value.indexOf(",") > -1) {
                RightsApplicator.checkOnlyPosOrNeg(value);
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreElements()) {
                boolean isNegative;
                String einWert = st.nextToken();
                boolean bl = isNegative = einWert.indexOf("-") > -1;
                if (einWert.indexOf("*") > -1) {
                    if (isNegative) {
                        rc.addAndRestriction(" " + dbfieldname + " not like '" + einWert.replace('*', '%') + "' ");
                        continue;
                    }
                    rc.addOrRestriction(" " + dbfieldname + "  like '" + einWert.replace('*', '%') + "' ");
                    continue;
                }
                this.arglist.set(1, StringUtils.replace(einWert, "-", ""));
                if (!field.hasKeys(false, einWert)) continue;
                if (isNegative) {
                    rc.addAndRestriction(" " + dbfieldname + " not in " + field.exec(this.arglist));
                    continue;
                }
                rc.addOrRestriction(" " + dbfieldname + "  in " + field.exec(this.arglist));
            }
            String result = "";
            if (rc.isSomethingAdded()) {
                result = "(" + rc.toString() + ") ";
            }
            return result;
        }

        public boolean hasAllRights() {
            return this.finanzstelle.equals("0") && this.hhprog.equals("0") && this.fonds.equals("0") && this.fipos.equals("0");
        }
    }
}

