/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.tree.admin.AdminTreeModel;
import de.memtext.tree.admin.EntryNode;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AdminTree
extends JTree
implements TreeModelListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
Autoscroll {
    private String tablename;
    private List entryNodes;
    private EntryNode prototypeEntry;
    private EntryNode root;
    private int lastRowOver = -1;

    public AdminTree(AdminTreeModel model, JPopupMenu popupMenu) {
        super(model);
        this.addMouseListener(new ShowPopUpMouseAdapter(popupMenu));
        this.setRootVisible(false);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, 2, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        TreePath path = this.getLeadSelectionPath();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Transferable tr = (Transferable)((Object)selectedNode);
        e.startDrag(DragSource.DefaultMoveDrop, tr, this);
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        e.acceptDrag(2);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            EntryNode selectedNode;
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            EntryNode movingNode = null;
            TreePath selectionPath = this.getLeadSelectionPath();
            movingNode = selectedNode = (EntryNode)selectionPath.getLastPathComponent();
            Point loc = e.getLocation();
            EntryNode newParent = (EntryNode)this.getPathForLocation(loc.x, loc.y).getLastPathComponent();
            model.removeNodeFromParent(movingNode);
            model.insertNodeInto(movingNode, newParent, newParent.getChildCount());
            movingNode.updateParentKey();
            e.acceptDrop(2);
            e.getDropTargetContext().dropComplete(true);
            TreePath parentPath = new TreePath(newParent.getPath());
            this.expandPath(parentPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        DefaultMutableTreeNode newChild = (DefaultMutableTreeNode)e.getChildren()[0];
        TreePath tp = new TreePath(newChild.getPath());
        this.expandPath(tp);
        this.makeVisible(tp);
        this.scrollPathToVisible(tp);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    @Override
    public void autoscroll(Point p) {
        int currentRow = this.getClosestRowForLocation(p.x, p.y);
        if (this.lastRowOver == -1) {
            this.lastRowOver = currentRow;
            return;
        }
        if (currentRow > this.lastRowOver) {
            this.scrollRowToVisible(currentRow + 1);
        } else if (currentRow > 0) {
            this.scrollRowToVisible(currentRow - 1);
        }
        this.lastRowOver = currentRow;
    }

    @Override
    public Insets getAutoscrollInsets() {
        int margin = 12;
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + margin, inner.x - outer.x + margin, outer.height - inner.height - inner.y + outer.y + margin, outer.width - inner.width - inner.x + outer.x + margin);
    }

    class ShowPopUpMouseAdapter
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        public ShowPopUpMouseAdapter(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.showPopupMenu(me);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.showPopupMenu(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.showPopupMenu(me);
            }
        }

        void showPopupMenu(MouseEvent event) {
            TreePath tp = AdminTree.this.getPathForLocation(event.getX(), event.getY());
            if (tp == null) {
                return;
            }
            AdminTree.this.setSelectionPath(tp);
            this.popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }
}

