/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.time;

import de.memtext.util.DateUtils;
import java.io.Serializable;
import java.util.Date;

public class Period
implements Serializable {
    private Date from;
    private Date till;
    private boolean isEternity;
    private static final long serialVersionUID = 1L;

    public Period(Object from, Object till) {
        if (from != null && !(from instanceof Date)) {
            throw new IllegalArgumentException("only Date allowed");
        }
        if (till != null && !(from instanceof Date)) {
            throw new IllegalArgumentException("only Date allowed");
        }
        if (from != null) {
            this.setFrom((Date)from);
        } else {
            this.setFrom(null);
        }
        if (till != null) {
            this.setTill((Date)till);
        } else {
            this.setTill(null);
        }
    }

    public Period(Date from, Date till) {
        this.from = from;
        this.till = till;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTill() {
        return this.till;
    }

    public void setFrom(Date date) {
        this.from = date;
    }

    public void setTill(Date date) {
        this.till = date;
    }

    public String toString() {
        return DateUtils.format(this.from) + " - " + DateUtils.format(this.till);
    }

    public boolean isEternity() {
        return this.isEternity;
    }

    public void setEternity(boolean isEternity) {
        this.isEternity = isEternity;
    }

    public boolean isInPeriod(Date date) {
        return this.isEternity || this.from.compareTo(date) <= 0 && this.till.compareTo(date) >= 0;
    }

    public static void main(String[] args) {
        Period validityPeriod = new Period(java.sql.Date.valueOf("1900-01-01"), java.sql.Date.valueOf("3000-01-01"));
        System.out.println(validityPeriod.isInPeriod(java.sql.Date.valueOf("1800-01-01")));
        System.out.println(validityPeriod.isInPeriod(java.sql.Date.valueOf("1900-01-01")));
        System.out.println(validityPeriod.isInPeriod(java.sql.Date.valueOf("2000-01-01")));
        System.out.println(validityPeriod.isInPeriod(java.sql.Date.valueOf("3000-01-01")));
        System.out.println(validityPeriod.isInPeriod(java.sql.Date.valueOf("3000-02-01")));
    }

    public Object clone() throws CloneNotSupportedException {
        Date clfrom = null;
        if (this.from != null) {
            clfrom = new Date(this.from.getTime());
        }
        Date cltill = null;
        if (this.till != null) {
            cltill = new Date(this.till.getTime());
        }
        Period cl = new Period(clfrom, cltill);
        cl.isEternity = this.isEternity;
        return cl;
    }

    public String getFromString() {
        String result = "";
        if (this.from != null) {
            result = DateUtils.formatGerman(this.from);
        }
        return result;
    }

    public String getTillString() {
        String result = "";
        if (this.till != null) {
            result = DateUtils.formatGerman(this.till);
        }
        return result;
    }
}

