/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureCredentialsExpiredEvent;
import org.springframework.security.authentication.event.AuthenticationFailureDisabledEvent;
import org.springframework.security.authentication.event.AuthenticationFailureExpiredEvent;
import org.springframework.security.authentication.event.AuthenticationFailureLockedEvent;
import org.springframework.security.authentication.event.AuthenticationFailureProviderNotFoundEvent;
import org.springframework.security.authentication.event.AuthenticationFailureProxyUntrustedEvent;
import org.springframework.security.authentication.event.AuthenticationFailureServiceExceptionEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class DefaultAuthenticationEventPublisher
implements AuthenticationEventPublisher,
ApplicationEventPublisherAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationEventPublisher applicationEventPublisher;
    private final Properties exceptionMappings;

    public DefaultAuthenticationEventPublisher() {
        this(null);
    }

    public DefaultAuthenticationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.exceptionMappings = new Properties();
        this.exceptionMappings.put(AccountExpiredException.class.getName(), AuthenticationFailureExpiredEvent.class.getName());
        this.exceptionMappings.put(AuthenticationServiceException.class.getName(), AuthenticationFailureServiceExceptionEvent.class.getName());
        this.exceptionMappings.put(LockedException.class.getName(), AuthenticationFailureLockedEvent.class.getName());
        this.exceptionMappings.put(CredentialsExpiredException.class.getName(), AuthenticationFailureCredentialsExpiredEvent.class.getName());
        this.exceptionMappings.put(DisabledException.class.getName(), AuthenticationFailureDisabledEvent.class.getName());
        this.exceptionMappings.put(BadCredentialsException.class.getName(), AuthenticationFailureBadCredentialsEvent.class.getName());
        this.exceptionMappings.put(UsernameNotFoundException.class.getName(), AuthenticationFailureBadCredentialsEvent.class.getName());
        this.exceptionMappings.put(ProviderNotFoundException.class.getName(), AuthenticationFailureProviderNotFoundEvent.class.getName());
        this.exceptionMappings.put("org.springframework.security.authentication.cas.ProxyUntrustedException", AuthenticationFailureProxyUntrustedEvent.class.getName());
    }

    public void publishAuthenticationSuccess(Authentication authentication) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authentication));
        }
    }

    public void publishAuthenticationFailure(AuthenticationException exception, Authentication authentication) {
        String className = this.exceptionMappings.getProperty(exception.getClass().getName());
        AbstractAuthenticationEvent event = null;
        if (className != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(Authentication.class, AuthenticationException.class);
                Object obj = constructor.newInstance(authentication, exception);
                Assert.isInstanceOf(AbstractAuthenticationEvent.class, obj, (String)"Must be an AbstractAuthenticationEvent");
                event = (AbstractAuthenticationEvent)((Object)obj);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
        }
        if (event != null) {
            if (this.applicationEventPublisher != null) {
                this.applicationEventPublisher.publishEvent(event);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No event was found for the exception " + exception.getClass().getName()));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setAdditionalExceptionMappings(Properties additionalExceptionMappings) {
        Assert.notNull((Object)additionalExceptionMappings, (String)"The exceptionMappings object must not be null");
        this.exceptionMappings.putAll((Map<?, ?>)additionalExceptionMappings);
    }
}

