/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.ui.swing.checkboxtree;

import de.werum.sis.ui.swing.checkboxtree.CheckBoxNodeRenderer;
import de.werum.sis.ui.swing.checkboxtree.CheckObject;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor,
ActionListener {
    private CheckBoxNodeRenderer renderer = null;
    private CheckObject currentEditCheckObject = null;

    public CheckBoxNodeEditor() {
        this(null);
    }

    public CheckBoxNodeEditor(TreeCellRenderer objectRenderer) {
        this.renderer = new CheckBoxNodeRenderer(objectRenderer);
        this.renderer.setMarkIfHasUnselectedChilds(false);
        this.renderer.getCheckBox().addActionListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        CheckObject checkObject = null;
        if (userObject instanceof CheckObject) {
            checkObject = (CheckObject)userObject;
            userObject = checkObject.getSelectObject();
        }
        this.currentEditCheckObject = checkObject != null ? checkObject : null;
        return this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentEditCheckObject != null) {
            this.currentEditCheckObject.setSelected(this.renderer.getCheckBox().isSelected());
            CheckObject checkObjectTemp = this.currentEditCheckObject;
            this.currentEditCheckObject = null;
            return checkObjectTemp;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }

    private boolean isInsideCheckBox(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getPathForLocation(me.getX(), me.getY());
            if (path != null) {
                Rectangle r = tree.getPathBounds(path);
                int x = me.getX() - r.x;
                int y = me.getY() - r.y;
                if (x > this.renderer.getCheckBox().getX() && x < this.renderer.getCheckBox().getPreferredSize().width) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return this.isInsideCheckBox(e);
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return !this.isInsideCheckBox(e);
    }
}

