/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.item.tree;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.item.tree.MappingTreeNode;
import de.werum.sis.mapping.item.tree.MappingTreeNodeImpl;
import de.werum.sis.mapping.item.tree.MappingTreePath;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MappingTreeModel
extends DefaultTreeModel
implements TreeModel {
    private static final long serialVersionUID = 3258129137502925108L;

    public MappingTreeModel() {
        super(new MappingTreeNodeImpl(), true);
    }

    public MappingTreeNode getSubTree(MappingTreePath path) {
        String treeRoot;
        String pathRoot = path.getPathComponent(0).toString();
        if (pathRoot.equals(treeRoot = ((MappingTreeNodeImpl)this.getRoot()).getDisplayName())) {
            return this.findSubTree(path, (MappingTreeNodeImpl)this.getRoot(), 0);
        }
        return null;
    }

    public MappingTreeNode getMappingTreeNode(TreePath path) {
        String treeRoot;
        String pathRoot = path.getPathComponent(0).toString();
        if (pathRoot.equals(treeRoot = ((MappingTreeNodeImpl)this.getRoot()).getDisplayName())) {
            return this.findSubTree(path, (MappingTreeNodeImpl)this.getRoot(), 0);
        }
        return null;
    }

    public void buildModel(MappingTreePath path) {
        if (path == null) {
            return;
        }
        MappingTreeNode _activNode = (MappingTreeNodeImpl)this.getRoot();
        MappingTreeNode _childNode = null;
        String _subpath = null;
        for (int pidx = 1; pidx < path.getPathCount(); ++pidx) {
            _subpath = path.getSubPath(pidx);
            _childNode = this.getChild(_activNode, _subpath);
            if (_childNode == null) {
                _childNode = new MappingTreeNodeImpl(_subpath);
                this.insertNodeInto(_childNode, _activNode, _activNode.getChildCount());
            }
            _activNode = _childNode;
        }
        if (path.getMappingElementObject().isStructure()) {
            _activNode.setUserObject(path.getMappingElementObject());
        } else {
            _childNode = new MappingTreeNodeImpl(path.getMappingElementObject(), path.getMappingElementObject().getKey(), false);
            this.insertNodeInto(_childNode, _activNode, _activNode.getChildCount());
        }
    }

    private MappingTreeNode getChild(MappingTreeNode startNode, String path) {
        if (startNode.getChildCount() == 0) {
            return null;
        }
        for (int i = 0; i < startNode.getChildCount(); ++i) {
            MappingTreeNodeImpl child = (MappingTreeNodeImpl)startNode.getChildAt(i);
            if (!child.getPathName().equals(path)) continue;
            return child;
        }
        return null;
    }

    private MappingTreeNode findSubTree(TreePath searchPath, MappingTreeNode startNode, int elNumber) {
        if (elNumber == searchPath.getPathCount() - 1) {
            return startNode;
        }
        String nextPath = searchPath.getPathComponent(elNumber + 1).toString();
        for (int i = 0; i < startNode.getChildCount(); ++i) {
            MappingTreeNode child = (MappingTreeNode)startNode.getChildAt(i);
            if (!child.getDisplayName().equals(nextPath)) continue;
            return this.findSubTree(searchPath, child, elNumber + 1);
        }
        return null;
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        if (parent.getIndex(newChild) >= 0) {
            Logger.getInstance().debug(this, "child(" + newChild.toString() + ") existiert bereits unter parent(" + parent.toString() + ")");
            return;
        }
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }
}

