/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherPacker;
import de.werum.sis.crypt.CryptProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class EncryptPwOutputStream
extends OutputStream {
    private CipherPacker cipherPacker = null;
    private CryptProperties properties = null;
    protected CipherOutputStream secureOut;

    public EncryptPwOutputStream(OutputStream _os, CryptProperties _properties, String _kennung, String _password) throws IOException {
        try {
            this.properties = _properties;
            this.cipherPacker = new CipherPacker(_properties);
            SecretKey symetric_key = null;
            Cipher symetric_cipher = Cipher.getInstance(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getSymetricOpMode(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getSymetricPadding(this.properties.getEncryptPackagingUserId()), this.properties.getProviderName(this.properties.getEncryptPackagingUserId()));
            SecureRandom secRand = null;
            KeyGenerator key_gen = KeyGenerator.getInstance(this.properties.getSymetricAlgorithm(this.properties.getEncryptPackagingUserId()), this.properties.getProviderName(this.properties.getEncryptPackagingUserId()));
            symetric_key = key_gen.generateKey();
            secRand = this.properties.getSecureRandom();
            if (secRand != null) {
                symetric_cipher.init(1, (Key)symetric_key, secRand);
            } else {
                symetric_cipher.init(1, symetric_key);
            }
            IvParameterSpec ivSpec = new IvParameterSpec(symetric_cipher.getIV());
            this.cipherPacker.packCipherDesPw(_os, symetric_cipher, symetric_key, _kennung, _password);
            this.secureOut = new CipherOutputStream(new BufferedOutputStream(_os), symetric_cipher);
        }
        catch (GeneralSecurityException ex) {
            ex.printStackTrace();
            throw new IOException("GeneralSecurityException :" + ex.getMessage());
        }
    }

    public void write(int b) throws IOException {
        this.secureOut.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.secureOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.secureOut.write(b, off, len);
    }

    public void write(String s) throws IOException {
        byte[] b = s.getBytes();
        this.secureOut.write(b);
    }

    public void close() throws IOException {
        if (this.secureOut != null) {
            this.secureOut.close();
        }
    }
}

